/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BrokerProductAccessor;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.utils.CollectionHelper;

public interface ProductsAccessor
extends ProcessableForProxying {
    public AdminProductAccessor admin();

    public BrokerProductAccessor broker();

    public Collection<? extends Product> getProducts();

    default public Class<?> getProxyClass() {
        return ProductsAccessor.class;
    }

    default public List<AccountType> grantedAccountTypes() {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(this.admin().getSystemAccounts());
        hashSet.addAll(this.userManagement().getUserAccountsAccess());
        hashSet.addAll(this.member().getUserAccounts());
        return CollectionHelper.sort(hashSet);
    }

    default public List<Currency> grantedCurrencies() {
        return this.grantedAccountTypes().stream().map(AccountType::getCurrency).distinct().sorted().collect(Collectors.toList());
    }

    default public boolean hasAdminProducts() {
        return this.getProducts().stream().anyMatch(product -> product instanceof AdminProduct);
    }

    default public boolean hasBrokerProducts() {
        return this.getProducts().stream().anyMatch(product -> product instanceof BrokerProduct);
    }

    default public boolean hasMemberProducts() {
        return this.getProducts().stream().anyMatch(product -> product instanceof MemberProduct);
    }

    public MemberProductAccessor member();

    public MemberProductAccessor member(UserAccountType var1);

    public MemberOrBrokerProductAccessor memberOrBroker();

    public ProductAccessor product();

    public UserManagementProductAccessor userManagement();
}

