/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWebService;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.QProductTransferStatusFlow;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.BooleanPropertiesHolderImpl;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.utils.StringHelper;

public class OidcProductAccessor<A extends ProductAccessor>
implements ProductAccessor {
    protected final OidcAccessToken token;
    protected final OidcAuthorization authorization;
    protected final BaseOidcClient client;
    protected final OidcClientAccessor accessor;
    protected final A delegate;
    protected final Set<Scope> scopes;
    protected final Set<Permission> permissions;
    private BooleanPropertiesHolder<ProfileField> myProfileFields;

    public OidcProductAccessor(OidcAccessToken oidcAccessToken, OidcClientAccessor oidcClientAccessor, A a, Set<Permission> set) {
        this.token = oidcAccessToken;
        this.authorization = oidcAccessToken.getAuthorization();
        this.client = this.authorization.getClient();
        this.accessor = oidcClientAccessor;
        this.scopes = EnumSet.noneOf(Scope.class);
        this.scopes.addAll(this.authorization.getScopes());
        this.scopes.retainAll(oidcClientAccessor.getScopes());
        this.delegate = a;
        this.permissions = set;
    }

    @Override
    public List<BasicGroup> getAccessibleUserGroups() {
        return this.delegate.getAccessibleUserGroups();
    }

    @Override
    public List<Agreement> getAgreements() {
        return this.delegate.getAgreements();
    }

    @Override
    public List<QuickAccess> getDefaultQuickAccess() {
        return Collections.emptyList();
    }

    @Override
    public List<DocumentCategory> getDocumentCategoryView() {
        return Collections.emptyList();
    }

    @Override
    public List<BasicGroup> getGroupsForUserDirectory() {
        return this.delegate.getGroupsForUserDirectory();
    }

    @Override
    public int getMaxAddresses() {
        return this.delegate.getMaxAddresses();
    }

    @Override
    public int getMaxCustomImages() {
        return 0;
    }

    @Override
    public int getMaxInvitationRecipients() {
        return 0;
    }

    @Override
    public int getMaxLandlinePhones() {
        return this.delegate.getMaxLandlinePhones();
    }

    @Override
    public int getMaxMessageRecipients() {
        return 0;
    }

    @Override
    public int getMaxMobilePhones() {
        return this.delegate.getMaxMobilePhones();
    }

    @Override
    public int getMaxProfileImages() {
        return this.delegate.getMaxProfileImages();
    }

    @Override
    public int getMaxSmsPerMonth() {
        return this.delegate.getMaxMobilePhones();
    }

    @Override
    public BooleanPropertiesHolder<AccessClientPrincipalType> getMyAccessClients() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<ContactCustomField> getMyContactFields() {
        return this.delegate.getMyContactFields();
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getMyProfileFields() {
        if (this.myProfileFields != null) {
            return this.myProfileFields;
        }
        boolean bl = this.scopes.contains(Scope.PROFILE_WRITE);
        BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder = this.delegate.getMyProfileFields();
        for (Map.Entry<ProfileField, BooleanProperties> entry : booleanPropertiesHolder.entries()) {
            ProfileField profileField = entry.getKey();
            BooleanProperties booleanProperties = entry.getValue();
            if (!this.canRead(profileField)) {
                booleanProperties.clear((Path<Boolean>)QProductMyProfileField.productMyProfileField.visible);
            }
            if (bl) continue;
            booleanProperties.clear((Path<Boolean>)QProductMyProfileField.productMyProfileField.editable);
        }
        this.myProfileFields = booleanPropertiesHolder;
        return this.myProfileFields;
    }

    @Override
    public BooleanPropertiesHolder<RecordCustomField> getMyRecordFields(UserRecordType userRecordType) {
        return this.delegate.getMyRecordFields(userRecordType);
    }

    @Override
    public BooleanPropertiesHolder<UserRecordType> getMyRecordTypes() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<PasswordType> getPasswordActions() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public List<Permission> getPermissions() {
        List<Permission> list = this.delegate.getPermissions();
        list.retainAll(this.permissions);
        return list;
    }

    @Override
    public List<Product> getProducts() {
        return this.delegate.getProducts();
    }

    @Override
    public List<Role> getRoles() {
        return this.delegate.getRoles();
    }

    @Override
    public List<CustomWebService> getRunCustomWebServices() {
        return Collections.emptyList();
    }

    @Override
    public List<CustomOperation> getRunTransferCustomOperations() {
        return Collections.emptyList();
    }

    @Override
    public List<ProfileField> getSimpleUserSearchProfileFields() {
        return this.delegate.getSimpleUserSearchProfileFields();
    }

    @Override
    public BooleanPropertiesHolder<TransferStatusFlow> getTransferStatusFlows() {
        if (!this.scopes.contains(Scope.ACCOUNT_HISTORY)) {
            return BooleanPropertiesHolderImpl.empty();
        }
        BooleanPropertiesHolder<TransferStatusFlow> booleanPropertiesHolder = this.delegate.getTransferStatusFlows();
        BooleanPath booleanPath = QProductTransferStatusFlow.productTransferStatusFlow.editable;
        booleanPropertiesHolder.keysSet((Path<Boolean>)booleanPath).forEach(transferStatusFlow -> booleanPropertiesHolder.get((TransferStatusFlow)transferStatusFlow).clear((Path<Boolean>)booleanPath));
        return booleanPropertiesHolder;
    }

    @Override
    public List<UserGroupAccessibility> getUserDirectoryOnGroups() {
        return Collections.emptyList();
    }

    @Override
    public List<UserGroupAccessibility> getUserGroupAccessibility() {
        return this.delegate.getUserGroupAccessibility();
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getUserProfileFields() {
        return this.delegate.getUserProfileFields();
    }

    @Override
    public List<TransactionCustomField> getVisibleTransactionFields() {
        return this.delegate.getVisibleTransactionFields();
    }

    @Override
    public List<VoucherCustomField> getVisibleVoucherFields() {
        return this.delegate.getVisibleVoucherFields();
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.delegate.hasPermission(permission) && this.permissions.contains(permission);
    }

    @Override
    public boolean hasRole(Role role) {
        return this.getRoles().contains(role);
    }

    @Override
    public boolean isEditMyProfile() {
        return this.scopes.contains(Scope.PROFILE_WRITE) && this.delegate.isEditMyProfile();
    }

    protected boolean canRead(ProfileField profileField) {
        boolean bl = this.scopes.contains(Scope.PROFILE_READ);
        if (bl) {
            return true;
        }
        if (profileField instanceof BasicProfileField) {
            switch ((BasicProfileField)profileField) {
                case FULL_NAME: 
                case LOGIN_NAME: 
                case IMAGE: {
                    return this.scopes.contains(Scope.PROFILE);
                }
                case EMAIL: {
                    return this.scopes.contains(Scope.EMAIL);
                }
                case PHONE: {
                    return this.scopes.contains(Scope.PHONE);
                }
                case ADDRESS: {
                    return this.scopes.contains(Scope.ADDRESS);
                }
                case ACCOUNT_NUMBER: {
                    return this.scopes.contains(Scope.ACCOUNT_HISTORY) || this.scopes.contains(Scope.ACCOUNT_STATUS) || this.scopes.contains(Scope.PAYMENT);
                }
            }
            return false;
        }
        if (profileField instanceof UserCustomField) {
            UserCustomField userCustomField = (UserCustomField)profileField;
            return this.scopes.contains(Scope.PROFILE) && StringHelper.isNotBlank((Object)userCustomField.getOidcClaim());
        }
        return false;
    }
}

