/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BrokerProductAccessor;
import org.cyclos.impl.users.EmptyAdminProductAccessor;
import org.cyclos.impl.users.EmptyBrokerProductAccessor;
import org.cyclos.impl.users.EmptyMemberProductAccessor;
import org.cyclos.impl.users.EmptyProductAccessor;
import org.cyclos.impl.users.EmptyUserManagementProductAccessor;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;

public class EmptyProductsAccessor
implements ProductsAccessor {
    private static final ProductsAccessor INSTANCE = new EmptyProductsAccessor();
    private Set<Access> accesses;
    private ProductsAccessor delegate;

    public static ProductsAccessor getInstance() {
        return INSTANCE;
    }

    public static ProductsAccessor getInstance(Set<Access> set, ProductsAccessor productsAccessor) {
        return new EmptyProductsAccessor(set, productsAccessor);
    }

    private EmptyProductsAccessor() {
        this(EnumSet.noneOf(Access.class), null);
    }

    private EmptyProductsAccessor(Set<Access> set, ProductsAccessor productsAccessor) {
        if (set == null || !set.isEmpty() && productsAccessor == null) {
            throw new IllegalArgumentException("Invalid parameters for empty products accessor");
        }
        this.accesses = set;
        this.delegate = productsAccessor;
    }

    @Override
    public AdminProductAccessor admin() {
        return EmptyAdminProductAccessor.getInstance();
    }

    @Override
    public BrokerProductAccessor broker() {
        return EmptyBrokerProductAccessor.getInstance();
    }

    @Override
    public Collection<? extends Product> getProducts() {
        return Collections.emptyList();
    }

    @Override
    public MemberProductAccessor member() {
        return EmptyMemberProductAccessor.getInstance();
    }

    @Override
    public MemberProductAccessor member(UserAccountType userAccountType) {
        return EmptyMemberProductAccessor.getInstance();
    }

    @Override
    public MemberOrBrokerProductAccessor memberOrBroker() {
        return this.member();
    }

    @Override
    public ProductAccessor product() {
        return this.accesses.isEmpty() ? EmptyProductAccessor.getInstance() : EmptyProductAccessor.getInstance(this.accesses, this.delegate.product());
    }

    @Override
    public UserManagementProductAccessor userManagement() {
        return EmptyUserManagementProductAccessor.getInstance();
    }

    public static enum Access {
        AGREEMENTS,
        MANAGE_PASSWORDS;

    }
}

