/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.impl.system.ProfilingEndEvent;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingEvent;
import org.cyclos.impl.system.ProfilingEventType;
import org.cyclos.impl.system.ProfilingLockEvent;
import org.cyclos.impl.system.ProfilingTransactionStartEvent;
import org.cyclos.utils.CollectionHelper;

public class ProfilingTransactionEndEvent
extends ProfilingEndEvent {
    private static final long serialVersionUID = 1L;

    public ProfilingTransactionEndEvent() {
    }

    public ProfilingTransactionEndEvent(ProfilingTransactionStartEvent profilingTransactionStartEvent, Boolean bl, Throwable throwable) {
        super.end(profilingTransactionStartEvent);
        profilingTransactionStartEvent.setCommitted(bl);
        if (throwable != null) {
            profilingTransactionStartEvent.setErrorTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
        }
    }

    @Override
    public ProfilingEventType getType() {
        return ProfilingEventType.TRANSACTION_END;
    }

    @Override
    public void onAdded(ProfilingEntry profilingEntry) {
        List<ProfilingEvent> list = profilingEntry.getEvents();
        int n = CollectionHelper.findIndex(list, profilingEvent -> this.getStartEventSeq().equals(profilingEvent.getSeq()));
        if (n >= 0) {
            for (int i = n; i < list.size(); ++i) {
                ProfilingEvent profilingEvent2 = list.get(i);
                if (!(profilingEvent2 instanceof ProfilingLockEvent)) continue;
                ProfilingLockEvent profilingLockEvent = (ProfilingLockEvent)profilingEvent2;
                profilingLockEvent.setDuration((int)(System.currentTimeMillis() - profilingLockEvent.getAcquiredAt().getTime()));
            }
        }
    }
}

