/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.model.system.imports.ImportedFileDataParams;

public interface ImportHandler<DTO extends ImportedFileDTO, D extends ImportedFileData, IF extends ImportedFile, E extends SimpleEntity> {
    public static boolean isImported(EntityDTO entityDTO) {
        return entityDTO == null ? false : Boolean.TRUE.equals(entityDTO.getAttribute("_import_"));
    }

    public static void markAsImported(EntityDTO entityDTO) {
        if (entityDTO != null) {
            entityDTO.setAttribute("_import_", (Object)true);
        }
    }

    public String fieldName(ImportedField var1);

    public void finishImport(IF var1);

    public Predicate<String> getAllowedImportFieldsPredicate(IF var1);

    public D getData(IF var1);

    public Class<E> getEntityClass();

    public List<ImportedField> getFieldsInList(IF var1);

    public Class<IF> getImportedFileClass();

    public ImportType getImportType();

    public Set<String> getMissingRequiredFields(IF var1, List<String> var2);

    public Object instantiateContext();

    public IF newEntity(ImportedFileDataParams var1);

    public IF newImportedFile(DTO var1);

    public void onImportError(ImportedLine var1, Throwable var2);

    public E processImportedLine(ImportedLine var1, Object var2);

    public Validator resolveValidator(DTO var1);

    public void validateImportedLine(ImportedLine var1, Object var2) throws ValidationException;
}

