/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.Serializable;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;

public class ExportFormatCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BuiltInExportFormat builtInExportFormat;
    private final String internalName;
    private final Long networkId;

    public ExportFormatCacheKey(BuiltInExportFormat builtInExportFormat) {
        this.builtInExportFormat = builtInExportFormat;
        this.internalName = builtInExportFormat.getInternalName();
        this.networkId = null;
    }

    public ExportFormatCacheKey(String string, Long l) {
        this.builtInExportFormat = BuiltInExportFormat.getByInternalName((String)string);
        this.internalName = string;
        this.networkId = this.builtInExportFormat == null ? l : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExportFormatCacheKey exportFormatCacheKey = (ExportFormatCacheKey)object;
        if (this.builtInExportFormat != exportFormatCacheKey.builtInExportFormat) {
            return false;
        }
        if (this.internalName == null ? exportFormatCacheKey.internalName != null : !this.internalName.equals(exportFormatCacheKey.internalName)) {
            return false;
        }
        return !(this.networkId == null ? exportFormatCacheKey.networkId != null : !this.networkId.equals(exportFormatCacheKey.networkId));
    }

    public BuiltInExportFormat getBuiltInExportFormat() {
        return this.builtInExportFormat;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.builtInExportFormat == null ? 0 : this.builtInExportFormat.hashCode());
        n = 31 * n + (this.internalName == null ? 0 : this.internalName.hashCode());
        n = 31 * n + (this.networkId == null ? 0 : this.networkId.hashCode());
        return n;
    }

    public String toString() {
        return this.internalName + "@" + (String)(this.networkId == null ? "<global>" : "network " + this.networkId);
    }
}

