/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.utils.CollectionHelper;

public class ChannelConfigurationCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long networkId;
    private final Long channelId;
    private final Long[] configurationPathIds;

    public ChannelConfigurationCacheKey(Long l, Long l2, List<Long> list) {
        this.networkId = l;
        this.channelId = l2;
        this.configurationPathIds = (Long[])list.toArray(Long[]::new);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChannelConfigurationCacheKey channelConfigurationCacheKey = (ChannelConfigurationCacheKey)object;
        return Objects.equals(this.channelId, channelConfigurationCacheKey.channelId) && Arrays.equals((Object[])this.configurationPathIds, (Object[])channelConfigurationCacheKey.configurationPathIds) && Objects.equals(this.networkId, channelConfigurationCacheKey.networkId);
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public Long getConfigurationId() {
        return (Long)CollectionHelper.first((Object[])this.configurationPathIds);
    }

    public Long[] getConfigurationPathIds() {
        return this.configurationPathIds;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode((Object[])this.configurationPathIds);
        n = 31 * n + Objects.hash(this.channelId, this.networkId);
        return n;
    }

    public boolean matches(Long l, Long l2) {
        return Objects.equals(this.channelId, l) && ArrayUtils.contains((Object[])this.configurationPathIds, (Object)l2);
    }

    public String toString() {
        return this.channelId + "," + this.getConfigurationId() + "@" + String.valueOf(this.networkId == null ? "global" : this.networkId);
    }
}

