/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import com.querydsl.jpa.JPQLTemplates;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.entities.banking.IUserAccount;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.messaging.OutgoingMessage;
import org.cyclos.entities.system.IpGeolocation;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CustomBean;
import org.cyclos.impl.banking.NativeAccountStatus;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.sql.AccountStatusUpdateParams;
import org.cyclos.impl.sql.AccountStatusUpdateResult;
import org.cyclos.impl.sql.CountConnectedUsersParams;
import org.cyclos.impl.sql.DatabaseVacuumInformation;
import org.cyclos.impl.sql.DbLockHandler;
import org.cyclos.impl.sql.InconsistentBalance;
import org.cyclos.impl.utils.notifications.NotificationProcessingEntityType;
import org.cyclos.impl.utils.tasks.BaseBackgroundTaskScheduling;
import org.cyclos.model.RetryException;
import org.cyclos.model.access.Role;
import org.cyclos.model.banking.accounts.BalanceEntryVO;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.cyclos.model.messaging.messages.SendMessageDTO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.utils.Pair;
import org.springframework.jdbc.core.JdbcTemplate;

public interface NativeQueryHandler
extends CustomBean {
    public long archiveAccountBalances();

    public long closeAccountBalances();

    public long copyLargeObject(long var1) throws IOException;

    public Map<Role, Integer> countConnectedUsers(CountConnectedUsersParams var1);

    public List<Pair<String, Long>> countUsersByUrl();

    public void deleteLargeObject(long var1);

    public List<InconsistentBalance> fixInconsistentAccountBalances(List<Long> var1);

    public List<BalanceEntryVO> getAccountBalanceHistory(Long var1, List<Date> var2);

    public Map<Account, NativeAccountStatus> getAccountStatuses(Collection<Account> var1, Date var2);

    public DatabaseInfo getDatabaseInfo();

    public DbLockHandler getDbLockHandler();

    public JPQLTemplates getJpaQueryTemplates();

    public Long getNextTransactionNumber();

    public Long getObjectId(long var1);

    public Date getRunningVacuumStart();

    public SearchHandler getSearchHandler();

    public DatabaseVacuumInformation getVacuumInfo();

    public long insertArchiveAccountFees();

    public long insertArchiveBulkActions();

    public long insertBackgroundTaskExecution(BaseBackgroundTaskScheduling<?> var1);

    public long insertEntityNotificationProcessingBackgroundTasks(NotificationProcessingEntityType<?> var1, int var2);

    public long insertIdRangeBackgroundTasks(Class<?> var1, long var2, long var4, String var6, Long var7);

    public long insertIpAddressLocalization(IpGeolocation var1);

    public long insertReindexBackgroundTasks(Class<? extends SimpleEntity> var1, String var2, int var3);

    public void insertTransferInitialStatus(TransferType var1, TransferStatus var2);

    public long insertUserAccountFeeLogs(AccountFeeLog var1);

    public void insertUserIncomingMessages(SendMessageDTO var1, MessageOwner var2, User var3, OutgoingMessage var4);

    public long insertUsersForBulkAction(Long var1, UserQuery var2);

    public boolean isConnectionError(SQLException var1);

    public List<Long> nextAccountIdsToClose(int var1, Date var2);

    public InputStream openLargeObject(long var1);

    public Pair<Set<String>, Set<Long>> purgeRemovedBuiltinLanguages();

    public long rebuildClosedAccountBalances(List<Long> var1);

    default public void retryIfConnectionError(Exception exception) throws RetryException {
        SQLException sQLException = (SQLException)ExceptionHelper.findCause((Throwable)exception, SQLException.class);
        if (sQLException != null && this.isConnectionError(sQLException)) {
            throw new RetryException("Connection error with SQLState=" + sQLException.getSQLState());
        }
    }

    public List<Long> scriptIdsMatchingContent(Long var1, String var2);

    public void setObjectId(long var1, long var3);

    public void storeLoginDate(BasicUser var1, Date var2);

    public boolean supportsBlobsInReadOnlyTransactions();

    public boolean tryLock(JdbcTemplate var1, LockKey var2);

    public boolean tryLock(LockKey var1);

    public List<AccountStatusUpdateResult> updateAccountStatuses(Collection<AccountStatusUpdateParams> var1);

    public Map<UserAccountType, IUserAccount> userAccounts(User var1, Collection<UserAccountType> var2, boolean var3, Integer var4);

    public void vacuum();

    public long writeLargeObject(InputStream var1) throws IOException;

    public static interface DatabaseInfo {
        public String getDriverName();

        public String getDriverVersion();

        public String getProductName();

        public String getProductVersion();
    }
}

