/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.cyclos.utils.ObjectHelper;

public class CachingResultSetMetaData
implements ResultSetMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColumnMetaData[] columns;
    private Map<String, ColumnMetaData> columnsByLabel;

    public CachingResultSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        this.columns = new ColumnMetaData[n];
        this.columnsByLabel = new HashMap<String, ColumnMetaData>(n);
        for (int i = 1; i <= n; ++i) {
            ColumnMetaData columnMetaData = new ColumnMetaData();
            columnMetaData.index = i;
            columnMetaData.autoIncrement = resultSetMetaData.isAutoIncrement(i);
            columnMetaData.caseSensitive = resultSetMetaData.isCaseSensitive(i);
            columnMetaData.searchable = resultSetMetaData.isSearchable(i);
            columnMetaData.currency = resultSetMetaData.isCurrency(i);
            columnMetaData.nullable = resultSetMetaData.isNullable(i);
            columnMetaData.signed = resultSetMetaData.isSigned(i);
            columnMetaData.displaySize = resultSetMetaData.getColumnDisplaySize(i);
            columnMetaData.label = resultSetMetaData.getColumnLabel(i);
            columnMetaData.name = resultSetMetaData.getColumnName(i);
            columnMetaData.schemaName = resultSetMetaData.getSchemaName(i);
            columnMetaData.precision = resultSetMetaData.getPrecision(i);
            columnMetaData.scale = resultSetMetaData.getScale(i);
            columnMetaData.tableName = resultSetMetaData.getTableName(i);
            columnMetaData.catalogName = resultSetMetaData.getCatalogName(i);
            columnMetaData.type = resultSetMetaData.getColumnType(i);
            columnMetaData.typeName = resultSetMetaData.getColumnTypeName(i);
            columnMetaData.readOnly = resultSetMetaData.isReadOnly(i);
            columnMetaData.writable = resultSetMetaData.isWritable(i);
            columnMetaData.definitelyWritable = resultSetMetaData.isDefinitelyWritable(i);
            columnMetaData.className = resultSetMetaData.getColumnClassName(i);
            this.columns[i - 1] = columnMetaData;
            this.columnsByLabel.put((String)ObjectHelper.defaultValue((Object)columnMetaData.label, (Object)columnMetaData.name), columnMetaData);
        }
    }

    public int findColumn(String string) throws SQLException {
        ColumnMetaData columnMetaData = this.columnsByLabel.get(string);
        if (columnMetaData == null) {
            throw new SQLException("No such column: " + string);
        }
        return columnMetaData.index;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return this.getColumn((int)n).catalogName;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return this.getColumn((int)n).className;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return this.getColumn((int)n).displaySize;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getColumn((int)n).label;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.getColumn((int)n).name;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        return this.getColumn((int)n).type;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return this.getColumn((int)n).typeName;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return this.getColumn((int)n).precision;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return this.getColumn((int)n).scale;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return this.getColumn((int)n).schemaName;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return this.getColumn((int)n).tableName;
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return this.getColumn((int)n).autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return this.getColumn((int)n).caseSensitive;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return this.getColumn((int)n).currency;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.getColumn((int)n).definitelyWritable;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return this.getColumn((int)n).nullable;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return this.getColumn((int)n).readOnly;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return this.getColumn((int)n).searchable;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return this.getColumn((int)n).signed;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return ResultSet.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return this.getColumn((int)n).writable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    private ColumnMetaData getColumn(int n) throws SQLException {
        try {
            return this.columns[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException(arrayIndexOutOfBoundsException);
        }
    }

    private static class ColumnMetaData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int index;
        private boolean autoIncrement;
        private boolean caseSensitive;
        private boolean searchable;
        private boolean currency;
        private int nullable;
        private boolean signed;
        private int displaySize;
        private String label;
        private String name;
        private String schemaName;
        private int precision;
        private int scale;
        private String tableName;
        private String catalogName;
        private int type;
        private String typeName;
        private boolean readOnly;
        private boolean writable;
        private boolean definitelyWritable;
        private String className;

        private ColumnMetaData() {
        }

        public String toString() {
            return "Metadata for " + this.name;
        }
    }
}

