/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.cyclos.impl.sql.CachingConnection;
import org.cyclos.impl.sql.DatabaseCachingMetadata;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.server.utils.JsonConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class CachingDataSource
implements DataSource {
    private final DataSource delegate;
    @Autowired
    @Lazy
    private CacheHandler cacheHandler;
    @Autowired
    @Lazy
    private JsonConverter jsonConverter;
    @Autowired
    private DatabaseCachingMetadata metadata;

    public CachingDataSource(DataSource dataSource) {
        this.delegate = dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new CachingConnection(this.metadata, this.cacheHandler, this.jsonConverter, this.delegate::getConnection);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.delegate.getConnection(string, string2);
    }

    public DataSource getDelegate() {
        return this.delegate;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.delegate.isWrapperFor(clazz);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.delegate.setLoginTimeout(n);
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.delegate.setLogWriter(printWriter);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return this.delegate.unwrap(clazz);
    }
}

