/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.AppI18nResourceBundle;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.app.AppSubmodule;
import org.cyclos.model.contentmanagement.translations.CustomizedTranslation;
import org.cyclos.model.contentmanagement.translations.TranslationKeyVO;
import org.cyclos.model.contentmanagement.translations.TranslationQuery;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.TranslationMapping;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Module;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.Submodule;

public class CyclosResourceBundle
extends ResourceBundle {
    private final CyclosResourceBundle parent;
    private final long languageId;
    private final BuiltinLanguage template;
    private final TranslationHandler translationHandler;
    private Map<Module, ResourceBundle> internalMap = new HashMap<Module, ResourceBundle>();

    public CyclosResourceBundle(CyclosResourceBundle cyclosResourceBundle, long l, BuiltinLanguage builtinLanguage, TranslationHandler translationHandler) {
        this.parent = cyclosResourceBundle;
        this.languageId = l;
        this.template = builtinLanguage;
        this.translationHandler = translationHandler;
    }

    public void addResourceBundle(Module module, ResourceBundle resourceBundle) {
        this.internalMap.put(module, resourceBundle);
    }

    public String get(MessageKey messageKey) {
        return this.getString(messageKey.fullKey());
    }

    public Map<String, String> getBySubmodule(Set<Submodule> set) {
        KeyAccessor keyAccessor = this.getKeyAccessor();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Submodule submodule : set) {
            List list = TranslationMapping.getBySubmodule((Submodule)submodule);
            for (MessageKey messageKey : list) {
                String string = messageKey.fullKey();
                try {
                    hashMap.put(string, keyAccessor.get(string));
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        return hashMap;
    }

    public Map<String, CustomizedTranslation> getCustomizedKeys() {
        if (this.translationHandler == null) {
            return Collections.emptyMap();
        }
        return this.translationHandler.getCustomizedKeys(this.languageId);
    }

    public CustomizedTranslation getCustomizedTranslation(String string) {
        return this.getCustomizedKeys().get(string);
    }

    public String getEvenIfInvalid(String string) {
        return this.doGetString(string, true);
    }

    public Map<String, String> getI18n() {
        List<Map<String, CustomizedTranslation>> list = this.getAllCustomizedKeys();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list2 = TranslationMapping.getBySubmodule((Submodule)AppSubmodule.TRANSLATIONS);
        AppI18nResourceBundle appI18nResourceBundle = (AppI18nResourceBundle)this.internalMap.get(Module.APP);
        for (MessageKey messageKey : list2) {
            CustomizedTranslation customizedTranslation = this.findCustomizedValue(list, messageKey.fullKey(), false);
            String string = null;
            if (customizedTranslation == null) {
                try {
                    string = appI18nResourceBundle.getString(messageKey.key());
                }
                catch (Exception exception) {
                    continue;
                }
            }
            hashMap.put(messageKey.key(), customizedTranslation == null ? string : customizedTranslation.getValue());
        }
        return hashMap;
    }

    @Override
    public Enumeration<String> getKeys() {
        return new KeyEnumeration();
    }

    public long getLanguageId() {
        return this.languageId;
    }

    public String getOriginal(MessageKey messageKey) {
        return this.getOriginalValue(messageKey.fullKey());
    }

    public String getOriginalValue(String string) {
        Module module;
        int n = string.indexOf(".");
        try {
            module = Module.valueOf((String)string.substring(0, n));
        }
        catch (Exception exception) {
            return null;
        }
        String string2 = string.substring(n + 1);
        return this.internalMap.get(module).getString(string2);
    }

    public CyclosResourceBundle getParent() {
        return this.parent;
    }

    public BuiltinLanguage getTemplate() {
        return this.template;
    }

    public String message(String string, MessageFormat messageFormat, Object ... objectArray) {
        String string2 = this.getString(string);
        string2 = this.formatMessage(string2, messageFormat);
        string2 = this.processArguments(string2, objectArray);
        return string2;
    }

    public Page<TranslationKeyVO> search(TranslationQuery translationQuery) {
        boolean bl;
        String string;
        Object object;
        String string2;
        Object object2;
        int n = translationQuery.getPageSize() == null || translationQuery.getPageSize() < 0 ? 40 : translationQuery.getPageSize();
        int n2 = Math.max((Integer)ObjectHelper.defaultValue((Object)translationQuery.getCurrentPage(), (Object)0), 0);
        Module module = translationQuery.getModule();
        Submodule submodule = translationQuery.getSubmodule();
        if (module != null && submodule != null && module != submodule.module()) {
            return PageImpl.empty((int)n, (int)n2);
        }
        List list = submodule != null ? TranslationMapping.getBySubmodule((Submodule)submodule) : (module != null ? TranslationMapping.getByModule((Module)module) : TranslationMapping.getAll());
        ArrayList<MessageKey> arrayList = new ArrayList<MessageKey>(list);
        if (translationQuery.isOnlyCustomized()) {
            object2 = this.getCustomizedKeys();
            arrayList.removeIf(messageKey -> !object2.containsKey(messageKey.fullKey()));
        }
        if (translationQuery.isOnlyInvalidCustomized()) {
            object2 = this.getCustomizedKeys();
            arrayList.removeIf(arg_0 -> CyclosResourceBundle.lambda$search$1((Map)object2, arg_0));
        }
        if ((object2 = StringHelper.trimToNull((Object)translationQuery.getKey())) != null) {
            arrayList.removeIf(arg_0 -> CyclosResourceBundle.lambda$search$2((String)object2, arg_0));
        }
        if ((string2 = StringHelper.trimToNull((Object)translationQuery.getEnglishTranslation())) != null) {
            object = this.translationHandler.getOriginalEnglishResourceBundle();
            arrayList.removeIf(arg_0 -> CyclosResourceBundle.lambda$search$3((CyclosResourceBundle)object, string2, arg_0));
        }
        if ((object = StringHelper.unaccent((String)StringHelper.trimToNull((Object)translationQuery.getCurrentTranslation()))) != null) {
            arrayList.removeIf(arg_0 -> this.lambda$search$4((String)object, arg_0));
        }
        if ((string = StringHelper.unaccent((String)StringHelper.trimToNull((Object)translationQuery.getOriginalTranslation()))) != null) {
            arrayList.removeIf(messageKey -> !StringUtils.containsIgnoreCase((CharSequence)StringHelper.unaccent((String)this.getOriginal((MessageKey)messageKey)), (CharSequence)string));
        }
        Page page = CollectionHelper.asPage(arrayList, (int)n, (int)n2);
        boolean bl2 = n == 0 ? false : (bl = translationQuery.isSkipTotalCount() || InvocationContext.getSessionData().getConfiguration().isSkipTotalCount());
        if (bl) {
            page = new PageImpl(page.getPageItems(), n, n2, null, page.isHasNextPage());
        }
        return PageImpl.transformed((Page)page, messageKey -> this.toTranslationKeyVO((MessageKey)messageKey, this.getAllCustomizedKeys()));
    }

    protected String doGetString(String string, boolean bl) {
        CustomizedTranslation customizedTranslation = this.getCustomizedKeys().get(string);
        if (customizedTranslation != null && (bl || !customizedTranslation.isInvalid())) {
            return customizedTranslation.getValue();
        }
        if (this.parent != null) {
            return this.parent.doGetString(string, bl);
        }
        return this.getOriginalValue(string);
    }

    @Override
    protected Object handleGetObject(String string) {
        return this.doGetString(string, false);
    }

    private CustomizedTranslation findCustomizedValue(List<Map<String, CustomizedTranslation>> list, String string, boolean bl) {
        for (Map<String, CustomizedTranslation> map : list) {
            CustomizedTranslation customizedTranslation = map.get(string);
            if (customizedTranslation == null || !bl && customizedTranslation.isInvalid()) continue;
            return customizedTranslation;
        }
        return null;
    }

    private String formatMessage(String string, MessageFormat messageFormat) {
        switch ((MessageFormat)ObjectHelper.defaultValue((Object)messageFormat, (Object)MessageFormat.PLAIN)) {
            case NEW_LINE_TO_BR: {
                string = StringHelper.removeMarkupTags((String)string, (boolean)false);
                string = StringHelper.convertNewLineToBr((String)string);
                break;
            }
            case HTML: {
                string = StringHelper.convertNewLineToBr((String)string);
                break;
            }
            case PLAIN: {
                string = StringHelper.removeMarkupTags((String)string, (boolean)false);
            }
        }
        return string;
    }

    private List<Map<String, CustomizedTranslation>> getAllCustomizedKeys() {
        ArrayList<Map<String, CustomizedTranslation>> arrayList = new ArrayList<Map<String, CustomizedTranslation>>();
        for (CyclosResourceBundle cyclosResourceBundle = this; cyclosResourceBundle != null; cyclosResourceBundle = cyclosResourceBundle.getParent()) {
            arrayList.add(cyclosResourceBundle.getCustomizedKeys());
        }
        return arrayList;
    }

    private KeyAccessor getKeyAccessor() {
        List<Map<String, CustomizedTranslation>> list = this.getAllCustomizedKeys();
        return new KeyAccessor(list);
    }

    private String processArguments(String string, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        if (CollectionHelper.isNotEmpty((Object[])objectArray)) {
            InvocationContext invocationContext = InvocationContext.ensure();
            RawEntityManagerHandler rawEntityManagerHandler = (RawEntityManagerHandler)invocationContext.applicationContext().getBean(RawEntityManagerHandler.class);
            Language language = rawEntityManagerHandler.find(Language.class, this.languageId);
            ConfigurationAccessor configurationAccessor = invocationContext.sessionData().getConfiguration().withLanguage(language);
            FormatterImpl formatterImpl = invocationContext.formatter(configurationAccessor);
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = formatterImpl.format(objectArray[i]);
                string2 = string2 == null ? null : Matcher.quoteReplacement(string2);
                string = string.replaceAll("\\{" + i + "\\}", string2 == null ? "" : string2);
            }
        }
        string = string.replaceAll("\\{\\d+\\}", "");
        return string;
    }

    private TranslationKeyVO toTranslationKeyVO(MessageKey messageKey, List<Map<String, CustomizedTranslation>> list) {
        String string = messageKey.fullKey();
        CustomizedTranslation customizedTranslation = this.findCustomizedValue(list, string, true);
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (customizedTranslation != null) {
            string2 = customizedTranslation.getValue();
            string3 = customizedTranslation.getSourceValue();
            bl = customizedTranslation.isInvalid();
        }
        String string4 = this.getOriginalValue(string);
        TranslationKeyVO translationKeyVO = new TranslationKeyVO();
        translationKeyVO.setKey(string);
        translationKeyVO.setCustomized(string2 != null);
        translationKeyVO.setInvalid(bl);
        translationKeyVO.setCurrentTranslation((String)ObjectHelper.defaultValue((Object)string2, (Object)string4));
        translationKeyVO.setOriginalTranslation(string4);
        translationKeyVO.setPreviousEnglishTranslation(bl ? string3 : null);
        translationKeyVO.setEnglishTranslation(this.translationHandler.getOriginalEnglishResourceBundle().getOriginalValue(string));
        return translationKeyVO;
    }

    private /* synthetic */ boolean lambda$search$4(String string, MessageKey messageKey) {
        return !StringUtils.containsIgnoreCase((CharSequence)StringHelper.unaccent((String)this.get(messageKey)), (CharSequence)string);
    }

    private static /* synthetic */ boolean lambda$search$3(CyclosResourceBundle cyclosResourceBundle, String string, MessageKey messageKey) {
        return !StringUtils.containsIgnoreCase((CharSequence)cyclosResourceBundle.get(messageKey), (CharSequence)string);
    }

    private static /* synthetic */ boolean lambda$search$2(String string, MessageKey messageKey) {
        return !StringUtils.containsIgnoreCase((CharSequence)messageKey.fullKey(), (CharSequence)string);
    }

    private static /* synthetic */ boolean lambda$search$1(Map map, MessageKey messageKey) {
        return !map.containsKey(messageKey.fullKey()) || !((CustomizedTranslation)map.get(messageKey.fullKey())).isInvalid();
    }

    private class KeyAccessor {
        private List<Map<String, CustomizedTranslation>> allCustomizedKeys;

        public KeyAccessor(List<Map<String, CustomizedTranslation>> list) {
            this.allCustomizedKeys = list;
        }

        private String get(String string) {
            CustomizedTranslation customizedTranslation = CyclosResourceBundle.this.findCustomizedValue(this.allCustomizedKeys, string, false);
            if (customizedTranslation == null) {
                return CyclosResourceBundle.this.getOriginalValue(string);
            }
            return customizedTranslation.getValue();
        }
    }

    private class KeyEnumeration
    implements Enumeration<String> {
        private Enumeration<String> keys;
        private Iterator<Map.Entry<Module, ResourceBundle>> resourceBundles;
        private Module currentModule;

        public KeyEnumeration() {
            this.resourceBundles = CyclosResourceBundle.this.internalMap.entrySet().iterator();
            this.nextResourceBundle();
        }

        @Override
        public boolean hasMoreElements() {
            return this.keys != null;
        }

        @Override
        public String nextElement() {
            String string = this.currentModule.name() + "." + this.keys.nextElement();
            if (!this.keys.hasMoreElements()) {
                this.nextResourceBundle();
            }
            return string;
        }

        private void nextResourceBundle() {
            if (this.resourceBundles.hasNext()) {
                Map.Entry<Module, ResourceBundle> entry = this.resourceBundles.next();
                this.currentModule = entry.getKey();
                this.keys = entry.getValue().getKeys();
                if (!this.keys.hasMoreElements()) {
                    this.nextResourceBundle();
                }
            } else {
                this.currentModule = null;
                this.keys = null;
            }
        }
    }
}

