/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Path;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountFeeTransfer;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InstallmentTransfer;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFee;
import org.cyclos.entities.banking.TransferFeeTransfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QProductTransferStatusFlow;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.ARateTypeHandler;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.VoucherDetailsOnPayment;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.rates.FormattableTimeBasedRate;
import org.cyclos.model.banking.transactions.BasePaymentData;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.PaymentAuthorizationLevelData;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.RecurringPaymentStatus;
import org.cyclos.model.banking.transactions.ScheduledPaymentStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionNature;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.springframework.beans.factory.annotation.Autowired;

public class TransWrapper
implements Trans,
ProcessableForProxying {
    @Autowired
    private AccountHandler accountHandler;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private DRateTypeHandler dRateHandler;
    @Autowired
    private ARateTypeHandler aRateHandler;
    @Autowired
    private VoucherServiceLocal voucherService;
    @Autowired
    private EntityManagerHandler entityManagerHandler;
    private Trans trans;
    private Transfer transfer;
    private Transaction transaction;
    private SessionData sessionData;
    private Date singleDate;
    private CurrencyAmount dueAmount;
    private TranslationMessageSpecification scheduling;
    private List<TransferStatus> transferStatuses;
    private VoucherDetailsOnPayment _voucherDetails;

    public TransWrapper(Trans trans) {
        Object object;
        boolean bl;
        this.trans = trans;
        this.transfer = (Transfer)ObjectHelper.ifType((Object)trans, Transfer.class);
        this.transaction = (Transaction)ObjectHelper.ifType((Object)trans, Transaction.class);
        this.sessionData = InvocationContext.getSessionData();
        Date date = this.getProcessDate();
        boolean bl2 = bl = date != null && Math.abs(date.getTime() - this.getSubmissionDate().getTime()) < 1000L;
        if (bl) {
            this.singleDate = date;
        }
        if (this.transfer instanceof InstallmentTransfer && this.transfer.getTransaction() instanceof ScheduledPayment) {
            object = (InstallmentTransfer)this.transfer;
            Installment installment = object.getInstallment();
            ScheduledPayment scheduledPayment = (ScheduledPayment)installment.getTransaction();
            Integer n = installment.getNumber();
            int n2 = scheduledPayment.getInstallmentCount();
            this.scheduling = new TranslationMessageSpecification(BankingKeys.Transactions.SCHEDULING_DETAILS, new Object[]{n, n2});
        }
        if (this.transfer != null && CollectionHelper.isNotEmpty((Iterable)this.transfer.getStatuses())) {
            object = CollectionHelper.sort(this.sessionData.getProducts().product().getTransferStatusFlows().keysSet((Path<Boolean>)QProductTransferStatusFlow.productTransferStatusFlow.visible));
            this.transferStatuses = object.stream().map(transferStatusFlow -> this.transfer.getStatus(transferStatusFlow)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    protected TransWrapper() {
    }

    public AccessClient getAccessClient() {
        return this.trans.getAccessClient();
    }

    public AccountFee getAccountFee() {
        if (this.sessionData.isAdmin() && this.transfer instanceof AccountFeeTransfer) {
            return ((AccountFeeTransfer)this.transfer).getAccountFee();
        }
        return null;
    }

    public BigDecimal getAmount() {
        return this.trans.getAmount();
    }

    public FormattableTimeBasedRate getARate() {
        Transfer transfer = this.getTransfer();
        if (transfer == null || !this.aRateHandler.isVisibleToUser(transfer.getCurrency(), transfer.getDate())) {
            return null;
        }
        BigDecimal bigDecimal = this.aRateHandler.convert(transfer.getEmissionDate(), transfer.getDate());
        return new FormattableTimeBasedRate(bigDecimal, BankingKeys.Rates.TRANSFER_MOMENTARY);
    }

    public Collection<Object> getAwaitingAuthBy() {
        BasePayment basePayment = this.getPayment();
        if (basePayment != null && basePayment.isPendingAuthorization()) {
            return this.getPotentialAuthorizers().stream().map(this::resolveLabelForAuthorizer).collect(Collectors.toList());
        }
        return null;
    }

    public List<VoucherVO> getBoughtVouchers() {
        VoucherDetailsOnPayment voucherDetailsOnPayment = this.getVoucherDetails();
        return voucherDetailsOnPayment == null ? null : voucherDetailsOnPayment.getBoughtVouchers();
    }

    public BasicUser getBy() {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : transaction.getBy();
    }

    public Channel getChannel() {
        return this.trans.getChannel();
    }

    public List<Transfer> getChildTransfers() {
        Transfer transfer = this.getTransfer();
        return transfer == null ? null : transfer.getChildren().stream().filter(this.entityManagerHandler::isAccessible).collect(Collectors.toList());
    }

    public String getComments() {
        Transaction transaction = this.getTransaction();
        if (transaction instanceof PaymentRequest) {
            return ((PaymentRequest)transaction).getComments();
        }
        if (transaction instanceof ExternalPayment) {
            return ((ExternalPayment)transaction).getComments();
        }
        return null;
    }

    public Currency getCurrency() {
        return this.trans.getCurrency();
    }

    public CurrencyAmount getCurrencyAmount() {
        return super.getCurrencyAmount();
    }

    public Set<TransactionCustomFieldValue> getCustomValues() {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : transaction.getCustomValues();
    }

    public Date getDate() {
        return this.trans.getDate();
    }

    public String getDescription() {
        Transaction transaction = this.getTransaction();
        String string = transaction == null ? null : transaction.getDescription();
        return (String)ObjectHelper.defaultValue((Object)string, (Object)this.getType().getValueForEmptyDescription());
    }

    public FormattableTimeBasedRate getDRate() {
        Transfer transfer = this.getTransfer();
        if (transfer == null || !this.dRateHandler.isVisibleToUser(transfer.getCurrency(), transfer.getDate())) {
            return null;
        }
        BigDecimal bigDecimal = this.dRateHandler.convert(transfer.getExpirationDate(), transfer.getDate());
        return new FormattableTimeBasedRate(bigDecimal, BankingKeys.Rates.TRANSFER_MOMENTARY);
    }

    public CurrencyAmount getDueAmount() {
        ScheduledPayment scheduledPayment;
        if (this.dueAmount == null && this.transaction instanceof ScheduledPayment && (scheduledPayment = (ScheduledPayment)this.transaction).getStatus() != ScheduledPaymentStatus.CANCELED) {
            BigDecimal bigDecimal = this.scheduledPaymentService.calculateDueAmount(scheduledPayment);
            this.dueAmount = new CurrencyAmount(this.getCurrency(), bigDecimal);
        }
        return this.dueAmount;
    }

    public Date getDueDate() {
        Installment installment;
        if (this.transaction instanceof ScheduledPayment && (installment = this.getInstallment()) != null) {
            return installment.getDueDate();
        }
        return null;
    }

    public Date getExpirationDate() {
        Transaction transaction = this.getTransaction();
        if (transaction instanceof PaymentRequest) {
            PaymentRequest paymentRequest = (PaymentRequest)transaction;
            return paymentRequest.getStatus() == PaymentRequestStatus.SCHEDULED || paymentRequest.getStatus() == PaymentRequestStatus.DENIED ? null : paymentRequest.getExpirationDate();
        }
        if (transaction instanceof Ticket) {
            return ((Ticket)transaction).getExpirationDate();
        }
        if (transaction instanceof ExternalPayment) {
            return ((ExternalPayment)transaction).getExpirationDate();
        }
        return null;
    }

    public Account getFrom() {
        return this.trans.getFrom();
    }

    public String getFromAccountNumber() {
        return this.accountHandler.getAccountNumber((IAccount)this.getFrom());
    }

    public String getFromName() {
        VoucherDetailsOnPayment voucherDetailsOnPayment = this.getVoucherDetails();
        if (voucherDetailsOnPayment != null) {
            return voucherDetailsOnPayment.getFromName();
        }
        return this.trans.getFromName();
    }

    public InternalAccountOwner getFromOwner() {
        return this.getFrom().getOwner();
    }

    public Object getFromOwnerOrType() {
        return super.getFromOwnerOrType();
    }

    public BasePayment getGeneratedPayment() {
        if (this.transaction instanceof PaymentRequest) {
            PaymentRequest paymentRequest = (PaymentRequest)this.transaction;
            return paymentRequest.getTransaction();
        }
        if (this.transaction instanceof Ticket) {
            Ticket ticket = (Ticket)this.transaction;
            return ticket.getPayment();
        }
        if (this.transaction instanceof ExternalPayment) {
            ExternalPayment externalPayment = (ExternalPayment)this.transaction;
            return externalPayment.getPayment();
        }
        return null;
    }

    public Long getId() {
        return this.trans.getId();
    }

    public Installment getInstallment() {
        ScheduledPayment scheduledPayment;
        if (this.transfer instanceof InstallmentTransfer) {
            return ((InstallmentTransfer)this.transfer).getInstallment();
        }
        if (this.transaction instanceof ScheduledPayment && (scheduledPayment = (ScheduledPayment)this.transaction).getInstallmentCount() == 1) {
            return scheduledPayment.getFirstInstallment();
        }
        return null;
    }

    public Date getNextOccurrenceDate() {
        RecurringPayment recurringPayment;
        if (this.transaction instanceof RecurringPayment && (recurringPayment = (RecurringPayment)this.transaction).getStatus() == RecurringPaymentStatus.OPEN) {
            return recurringPayment.getNextOccurrenceDate();
        }
        return null;
    }

    public Date getNextOcurrenceDate() {
        if (this.transaction instanceof RecurringPayment) {
            RecurringPayment recurringPayment = (RecurringPayment)this.transaction;
            return recurringPayment.getNextOccurrenceDate();
        }
        return null;
    }

    public Object getOccurrencesCount() {
        if (this.transaction instanceof RecurringPayment) {
            RecurringPayment recurringPayment = (RecurringPayment)this.transaction;
            Integer n = recurringPayment.getOccurrencesCount();
            if (n == null) {
                return BankingKeys.Transactions.PROCESS_UNTIL_CANCEL;
            }
            return new TranslationMessageSpecification(BankingKeys.Transactions.PROCESS_UNTIL_NUMBER_LABEL, new Object[]{n});
        }
        return null;
    }

    public TimeInterval getOccurrencesInterval() {
        if (this.transaction instanceof RecurringPayment) {
            RecurringPayment recurringPayment = (RecurringPayment)this.transaction;
            return recurringPayment.getOccurrenceInterval();
        }
        return null;
    }

    public Transfer getParentTransfer() {
        Transfer transfer;
        Transfer transfer2 = this.getTransfer();
        Transfer transfer3 = transfer = transfer2 == null ? null : transfer2.getParent();
        if (transfer != null && !this.entityManagerHandler.isAccessible((IEntity)transfer)) {
            transfer = null;
        }
        return transfer;
    }

    public BasePayment getPayment() {
        return (BasePayment)ObjectHelper.ifType((Object)this.getTransaction(), BasePayment.class);
    }

    public Date getProcessDate() {
        if (this.transaction instanceof PaymentRequest) {
            PaymentRequest paymentRequest = (PaymentRequest)this.transaction;
            return paymentRequest.getProcessDate();
        }
        if (this.transaction instanceof ExternalPayment) {
            ExternalPayment externalPayment = (ExternalPayment)this.transaction;
            return externalPayment.getProcessDate();
        }
        if (this.transaction instanceof Ticket) {
            Ticket ticket = (Ticket)this.transaction;
            return ticket.getProcessDate();
        }
        if (this.transfer != null) {
            return this.transfer.getDate();
        }
        return null;
    }

    public BasicUser getReceivedBy() {
        BasePayment basePayment = this.getPayment();
        return basePayment != null ? basePayment.getReceivedBy() : null;
    }

    public TranslationMessageSpecification getScheduling() {
        return this.scheduling;
    }

    public Date getSchedulingDate() {
        if (this.transaction instanceof ScheduledPayment) {
            ScheduledPayment scheduledPayment = (ScheduledPayment)this.transaction;
            return scheduledPayment.getInstallmentsCount() == 1 ? ((ScheduledPaymentInstallment)scheduledPayment.getInstallments().get(0)).getDueDate() : null;
        }
        return null;
    }

    public Date getSingleDate() {
        return this.singleDate;
    }

    public Object getStatus() {
        BasePayment basePayment = this.getPayment();
        if (basePayment != null && !basePayment.isAuthorized()) {
            return basePayment.getAuthorizationStatus();
        }
        if (this.transaction instanceof ScheduledPayment) {
            ScheduledPayment scheduledPayment = (ScheduledPayment)this.transaction;
            return scheduledPayment.getInstallmentsCount() == 1 ? ((ScheduledPaymentInstallment)CollectionHelper.first((Iterable)scheduledPayment.getInstallments())).getStatus() : scheduledPayment.getStatus();
        }
        if (this.transaction instanceof HasTransactionStatus) {
            return ((HasTransactionStatus)this.transaction).getStatus();
        }
        return null;
    }

    public Date getSubmissionDate() {
        if (this.transaction != null) {
            return this.transaction.getDate();
        }
        return this.trans.getDate();
    }

    public Account getTo() {
        return this.trans.getTo();
    }

    public String getToAccountNumber() {
        return this.accountHandler.getAccountNumber((IAccount)this.getTo());
    }

    public String getToName() {
        VoucherDetailsOnPayment voucherDetailsOnPayment = this.getVoucherDetails();
        if (voucherDetailsOnPayment != null) {
            return voucherDetailsOnPayment.getToName();
        }
        return this.trans.getToName();
    }

    public Object getToOwnerOrType() {
        return super.getToOwnerOrType();
    }

    public PrincipalType getToPrincipalType() {
        if (this.transaction instanceof ExternalPayment) {
            return ((ExternalPayment)this.transaction).getToPrincipalType();
        }
        return null;
    }

    public String getToPrincipalValue() {
        if (this.transaction instanceof ExternalPayment) {
            return ((ExternalPayment)this.transaction).getToPrincipalValue();
        }
        return null;
    }

    public Transaction getTransaction() {
        if (this.transaction != null) {
            return this.transaction;
        }
        if (this.transfer != null) {
            return this.transfer.getTransaction();
        }
        return null;
    }

    public String getTransactionFromName() {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : transaction.getFromName();
    }

    public String getTransactionNumber() {
        return this.trans.getTransactionNumber();
    }

    public String getTransactionToName() {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : transaction.getToName();
    }

    public Transfer getTransfer() {
        if (this.transfer != null) {
            return this.transfer;
        }
        if (this.transaction instanceof Payment) {
            return ((Payment)this.transaction).getTransfer();
        }
        return null;
    }

    public TransferFee getTransferFee() {
        if (this.sessionData.isAdmin() && this.trans instanceof TransferFeeTransfer) {
            return ((TransferFeeTransfer)this.trans).getTransferFee();
        }
        return null;
    }

    public List<TransferStatus> getTransferStatuses() {
        return this.transferStatuses;
    }

    public TransferType getType() {
        return this.trans.getType();
    }

    public VoucherTransactionResultVO getVoucherTransaction() {
        VoucherDetailsOnPayment voucherDetailsOnPayment = this.getVoucherDetails();
        return voucherDetailsOnPayment == null ? null : voucherDetailsOnPayment.getVoucherTransaction();
    }

    public boolean isExternalPayment() {
        return this.trans instanceof ExternalPayment;
    }

    public boolean isPaymentRequest() {
        return this.trans instanceof PaymentRequest;
    }

    public boolean isRecurringPayment() {
        return this.trans instanceof RecurringPayment;
    }

    public boolean isSent() {
        return this.trans instanceof Ticket || this.trans instanceof PaymentRequest;
    }

    public boolean isShowAmountAsTotal() {
        return this.trans instanceof ScheduledPayment;
    }

    public boolean isShowDueAmount() {
        boolean bl;
        boolean bl2 = bl = this.getDueAmount() != null;
        if (this.transaction instanceof ScheduledPayment) {
            return ((ScheduledPayment)this.transaction).getInstallmentsCount() != 1 && bl;
        }
        return bl;
    }

    public boolean isVoucherRedeem() {
        VoucherTransactionResultVO voucherTransactionResultVO = this.getVoucherTransaction();
        return voucherTransactionResultVO != null && voucherTransactionResultVO.getNature() == VoucherTransactionNature.REDEEM;
    }

    public boolean isVoucherTopUp() {
        VoucherTransactionResultVO voucherTransactionResultVO = this.getVoucherTransaction();
        return voucherTransactionResultVO != null && voucherTransactionResultVO.getNature() == VoucherTransactionNature.TOP_UP;
    }

    public Object resolveLabelForAuthorizer(AccountOwner accountOwner) {
        if (accountOwner != null && this.transaction != null) {
            if (accountOwner.equals((Object)SystemAccountOwner.instance())) {
                return new TranslationMessageSpecification(BankingKeys.Transactions.AWAITING_AUTHORIZATION_BY_ADMIN);
            }
            if (accountOwner instanceof BrokerAccount) {
                if (((BrokerAccount)accountOwner).hasBroker) {
                    return new TranslationMessageSpecification(BankingKeys.Transactions.AWAITING_AUTHORIZATION_BY_BROKER);
                }
                return new TranslationMessageSpecification(BankingKeys.Transactions.AWAITING_AUTHORIZATION_BY_MISSING_BROKER);
            }
            if (accountOwner instanceof OperatorOwner) {
                OperatorOwner operatorOwner = (OperatorOwner)accountOwner;
                return new TranslationMessageSpecification(BankingKeys.Transactions.AWAITING_AUTHORIZATION_BY_OPERATOR_OWNER, new Object[]{operatorOwner.user.getDisplay()});
            }
            if (this.transaction.getFrom() != null && accountOwner.equals((Object)this.transaction.getFrom().getOwner())) {
                return new TranslationMessageSpecification(BankingKeys.Transactions.AWAITING_AUTHORIZATION_BY_PAYER);
            }
            if (this.transaction.getTo() != null && accountOwner.equals((Object)this.transaction.getTo().getOwner())) {
                return new TranslationMessageSpecification(BankingKeys.Transactions.AWAITING_AUTHORIZATION_BY_RECEIVER);
            }
        }
        return null;
    }

    private List<AccountOwner> getPotentialAuthorizers() {
        BasePayment basePayment = this.getPayment();
        if (basePayment == null || !basePayment.isPendingAuthorization()) {
            return null;
        }
        BasePaymentData basePaymentData = (BasePaymentData)this.transactionService.getData(new TransactionVO(basePayment.getId()));
        TransactionAuthorizationType transactionAuthorizationType = basePaymentData.getAuthorizationType();
        if (transactionAuthorizationType != null) {
            ArrayList<AccountOwner> arrayList = new ArrayList<AccountOwner>();
            switch (transactionAuthorizationType) {
                case OPERATOR: {
                    AccountVO accountVO = basePaymentData.getTransaction().getFrom();
                    if (accountVO == null || !(accountVO.getOwner() instanceof UserVO)) break;
                    arrayList.add(new OperatorOwner((UserVO)accountVO.getOwner()));
                    break;
                }
                case LEVEL: {
                    PaymentAuthorizationLevelData paymentAuthorizationLevelData = basePaymentData.getAuthorizationLevelData();
                    if (paymentAuthorizationLevelData.isAllowPayer() && this.transaction.getFrom() != null && this.transaction.getFrom().getOwner() instanceof UserVO) {
                        arrayList.add((AccountOwner)this.transaction.getFrom().getOwner());
                    }
                    if (paymentAuthorizationLevelData.isAllowReceiver() && this.transaction.getTo() != null && this.transaction.getTo().getOwner() instanceof UserVO) {
                        arrayList.add((AccountOwner)this.transaction.getTo().getOwner());
                    }
                    if (paymentAuthorizationLevelData.isAllowBroker()) {
                        arrayList.add(new BrokerAccount(CollectionHelper.isNotEmpty((Iterable)basePaymentData.getAuthorizingBrokers())));
                    }
                    if (!paymentAuthorizationLevelData.isAllowAdmin()) break;
                    arrayList.add((AccountOwner)SystemAccountOwner.instance());
                    break;
                }
                case NA: {
                    return null;
                }
            }
            return arrayList;
        }
        return null;
    }

    private VoucherDetailsOnPayment getVoucherDetails() {
        BasePayment basePayment = this.getPayment();
        if (this._voucherDetails == null && basePayment instanceof Payment) {
            this._voucherDetails = this.voucherService.getDetailsOnPayment((Payment)basePayment);
        }
        return this._voucherDetails;
    }

    private class BrokerAccount
    implements AccountOwner {
        private boolean hasBroker;

        public BrokerAccount(boolean bl) {
            this.hasBroker = bl;
        }
    }

    private class OperatorOwner
    implements AccountOwner {
        private UserVO user;

        public OperatorOwner(UserVO userVO) {
            this.user = userVO;
        }
    }
}

