/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.QTransferStatus;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.impl.banking.BuildTransQueryParams;
import org.cyclos.model.banking.accounts.BaseTransferQuery;

public class BuildTransferQueryParams
extends BuildTransQueryParams<BaseTransferQuery> {
    private final Account account;
    private List<TransferStatusFlow> statusFlows;
    private boolean includeImage;
    private Map<TransactionCustomField, QTransactionCustomFieldValue> fieldValuePaths = new LinkedHashMap<TransactionCustomField, QTransactionCustomFieldValue>();
    private Map<TransferStatusFlow, QTransferStatus> statusPaths = new LinkedHashMap<TransferStatusFlow, QTransferStatus>();

    public BuildTransferQueryParams(Account account, BaseTransferQuery baseTransferQuery) {
        super(baseTransferQuery);
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public QTransactionCustomFieldValue getCustomValuePath(TransactionCustomField transactionCustomField) {
        return this.fieldValuePaths.get(transactionCustomField);
    }

    public Set<Map.Entry<TransactionCustomField, QTransactionCustomFieldValue>> getFieldValuePaths() {
        return this.fieldValuePaths.entrySet();
    }

    public List<TransferStatusFlow> getStatusFlows() {
        return this.statusFlows;
    }

    public QTransferStatus getStatusPath(TransferStatusFlow transferStatusFlow) {
        return this.statusPaths.get(transferStatusFlow);
    }

    public Set<Map.Entry<TransferStatusFlow, QTransferStatus>> getStatusPaths() {
        return this.statusPaths.entrySet();
    }

    public boolean isIncludeImage() {
        return this.includeImage;
    }

    public void setCustomValuePath(TransactionCustomField transactionCustomField, QTransactionCustomFieldValue qTransactionCustomFieldValue) {
        this.fieldValuePaths.put(transactionCustomField, qTransactionCustomFieldValue);
    }

    public void setIncludeImage(boolean bl) {
        this.includeImage = bl;
    }

    public void setStatusFlows(List<TransferStatusFlow> list) {
        this.statusFlows = list;
    }

    public void setStatusPath(TransferStatusFlow transferStatusFlow, QTransferStatus qTransferStatus) {
        this.statusPaths.put(transferStatusFlow, qTransferStatus);
    }
}

