/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.ChargebackTransfer;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValue;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValueCategory;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;

public class AccountHistoryEntry
implements Trans,
ProcessableForProxying,
EntityWithCustomValues<TransactionCustomField, TransactionCustomFieldPossibleValueCategory, TransactionCustomFieldPossibleValue, TransactionCustomFieldValue> {
    private Account account;
    private Transfer transfer;
    private boolean forExport;

    public AccountHistoryEntry(Account account, Transfer transfer, boolean bl) {
        this.account = account;
        this.transfer = transfer;
        this.forExport = bl;
    }

    protected AccountHistoryEntry() {
    }

    public AccessClient getAccessClient() {
        return this.transfer.getAccessClient();
    }

    public Account getAccount() {
        return this.account;
    }

    public BigDecimal getAmount() {
        BigDecimal bigDecimal = this.transfer.getAmount().setScale(this.getCurrency().getPrecision());
        if (this.account.equals((Object)this.transfer.getFrom())) {
            bigDecimal = bigDecimal.negate();
        }
        return bigDecimal;
    }

    public Channel getChannel() {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : transaction.getChannel();
    }

    public Currency getCurrency() {
        return this.transfer.getCurrency();
    }

    public Class<TransactionCustomField> getCustomFieldClass() {
        return TransactionCustomField.class;
    }

    public Class<TransactionCustomFieldValue> getCustomFieldValueClass() {
        return TransactionCustomFieldValue.class;
    }

    public Set<TransactionCustomFieldValue> getCustomValues() {
        Transaction transaction;
        Set set = null;
        set = this.forExport ? this.transfer.getCustomValuesForExport() : ((transaction = this.getTransaction()) == null ? null : transaction.getCustomValues());
        return set == null ? Collections.emptySet() : set;
    }

    public Date getDate() {
        return this.transfer.getDate();
    }

    public Object getDescription() {
        String string;
        Transaction transaction;
        if (this.transfer instanceof ChargebackTransfer) {
            transaction = ((ChargebackTransfer)this.transfer).getChargebackOf();
            Object object = string = transaction == null ? null : transaction.getTransaction();
            if (string != null) {
                String string2 = string.getDescription();
                MessageKey messageKey = StringHelper.isBlank((Object)string2) ? BankingKeys.Transfers.NATURE_CHARGEBACK : BankingKeys.Transfers.CHARGEBACK_DESCRIPTION;
                return new TranslationMessageSpecification(messageKey, new Object[]{string2});
            }
        }
        string = (transaction = this.transfer.getTransaction()) == null ? null : transaction.getDescription();
        return string == null ? this.transfer.getType().getValueForEmptyDescription() : string;
    }

    public Account getFrom() {
        return this.transfer.getFrom();
    }

    public String getFromName() {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : transaction.getFromName();
    }

    public Long getId() {
        return this.transfer.getId();
    }

    public Object getRelated() {
        String string;
        boolean bl = this.isDebit();
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            String string2 = string = bl ? transaction.getToName() : transaction.getFromName();
            if (string != null) {
                return string;
            }
        }
        Object object = string = bl ? this.transfer.getTo() : this.transfer.getFrom();
        if (string instanceof SystemAccount) {
            return string.getType();
        }
        return string.getOwner();
    }

    public Account getRelatedAccount() {
        return this.isDebit() ? this.transfer.getTo() : this.transfer.getFrom();
    }

    public Object getRelatedUser() {
        return ObjectHelper.ifType((Object)this.getRelatedAccount().getOwner(), User.class);
    }

    public List<TransferStatus> getStatuses(List<TransferStatusFlow> list) {
        ArrayList<TransferStatus> arrayList = new ArrayList<TransferStatus>(list.size());
        for (TransferStatusFlow transferStatusFlow : list) {
            TransferStatus transferStatus = this.transfer.getStatus(transferStatusFlow);
            if (transferStatus == null) continue;
            arrayList.add(transferStatus);
        }
        return arrayList;
    }

    public Account getTo() {
        return this.transfer.getTo();
    }

    public String getToName() {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : transaction.getToName();
    }

    public Transaction getTransaction() {
        return this.transfer.getTransaction();
    }

    public String getTransactionNumber() {
        return this.transfer.getTransactionNumber();
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public TransferType getType() {
        return this.transfer.getType();
    }

    public boolean isCredit() {
        return this.account.equals((Object)this.transfer.getTo());
    }

    public boolean isDebit() {
        return this.account.equals((Object)this.transfer.getFrom());
    }

    public void setAccount(Account account) {
        this.account = account;
    }
}

