/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import org.cyclos.entities.access.Pin;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.users.users.UserLocatorVO;

public class StatelessUserSessionData
extends UserSessionData {
    private final String channelName;
    private final String principalType;
    private final String principal;
    private final String password;
    private boolean allowIfPwdExpired;
    private boolean forLogin;
    private SessionHandler.UserCheckResult userCheckResult;

    StatelessUserSessionData(boolean bl, boolean bl2, String string, String string2, String string3, String string4, RequestData requestData) {
        super(requestData);
        this.channelName = string;
        this.principalType = string2;
        this.principal = string3;
        this.password = string4;
        this.allowIfPwdExpired = bl2;
        this.forLogin = bl;
    }

    @Override
    public String getAccessChannelName() {
        return this.getChannelName();
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public Pin getPin() {
        return this.userCheckResult().getPin();
    }

    @Override
    protected Long doGetLoggedBasicUserId() {
        return this.userCheckResult().getUser().getId();
    }

    @Override
    protected UserPrincipal doGetUserPrincipal() {
        return this.userCheckResult().getLocateUserResult();
    }

    private SessionHandler.UserCheckResult userCheckResult() {
        if (this.userCheckResult == null) {
            this.runAsSystem(() -> {
                Network network = this.getNetwork();
                String string = this.getRemoteAddress();
                UserLocatorVO userLocatorVO = new UserLocatorVO();
                userLocatorVO.setPrincipalType(this.principalType);
                userLocatorVO.setPrincipal(this.principal);
                SessionHandler sessionHandler = InvocationContext.bean(SessionHandler.class);
                this.userCheckResult = sessionHandler.checkUserAccess(this.forLogin, this.allowIfPwdExpired || this.forLogin, network, this.channelName, string, userLocatorVO, this.password, null);
                return null;
            });
        }
        return this.userCheckResult;
    }
}

