/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.io.Serializable;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;

public class SessionDataSubjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SessionDataSubject subject;
    private final Long entityId;

    public static SessionDataSubjectId guest(Configuration configuration) {
        return new SessionDataSubjectId(SessionDataSubject.GUEST, SimpleEntity.id((SimpleEntity)configuration));
    }

    public static SessionDataSubjectId system(Network network) {
        return new SessionDataSubjectId(SessionDataSubject.SYSTEM, SimpleEntity.id((SimpleEntity)network));
    }

    public static SessionDataSubjectId user(BasicUser basicUser) {
        return new SessionDataSubjectId(SessionDataSubject.USER, SimpleEntity.id((SimpleEntity)basicUser));
    }

    protected SessionDataSubjectId(SessionDataSubject sessionDataSubject, Long l) {
        this.subject = sessionDataSubject;
        this.entityId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SessionDataSubjectId sessionDataSubjectId = (SessionDataSubjectId)object;
        if (this.entityId == null ? sessionDataSubjectId.entityId != null : !this.entityId.equals(sessionDataSubjectId.entityId)) {
            return false;
        }
        return this.subject == sessionDataSubjectId.subject;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public SessionDataSubject getSubject() {
        return this.subject;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.entityId == null ? 0 : this.entityId.hashCode());
        n = 31 * n + (this.subject == null ? 0 : this.subject.hashCode());
        return n;
    }

    public String toString() {
        return String.valueOf((Object)this.subject) + "#" + this.entityId;
    }

    public static enum SessionDataSubject {
        SYSTEM,
        GUEST,
        USER;

    }
}

