/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelSettingsAccessor;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.DelegatingUserPrincipal;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.RoleContainer;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionDataSubjectId;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.login.UserAuthVO;
import org.cyclos.utils.CollectionHelper;

public interface SessionData
extends RoleContainer,
DelegatingUserPrincipal,
ProcessableForProxying {
    public void checkConsistency() throws InvalidSessionDataException;

    public Channel getAccessChannel();

    public String getAccessChannelName();

    public Set<BasicGroup> getAccessibleBasicGroups();

    public OidcAccessToken getAccessToken();

    public UserAuthVO getAuthenticatedUser();

    public Channel getChannel();

    public ChannelAccessAccessor getChannelAccessAccessor();

    public String getChannelName();

    public ChannelSettingsAccessor getChannelSettingsAccessor();

    public ConfigurationAccessor getConfiguration();

    public Group getGroup();

    public IdentityProvider getIdentityProvider();

    public BasicUser getLoggedBasicUser();

    public Operator getLoggedOperator();

    public User getLoggedUser();

    public Network getNetwork();

    public Pin getPin();

    public ProductsAccessor getProducts();

    default public Class<?> getProxyClass() {
        return SessionData.class;
    }

    public String getRemoteAddress();

    public RequestData getRequestData();

    public Session getSession();

    public SessionDataSubjectId getSubjectId();

    public boolean hasPermission(Permission var1);

    default public boolean hasPermission(Permission ... permissionArray) {
        if (CollectionHelper.isEmpty((Object[])permissionArray)) {
            return true;
        }
        return Stream.of(permissionArray).anyMatch(this::hasPermission);
    }

    public boolean hasRequiredValue(Permission var1, Object var2);

    default public <S extends SessionData> void ifWraps(Class<S> clazz, Consumer<S> consumer) {
        SessionData sessionData = this.unwrap();
        if (clazz.isInstance(sessionData)) {
            consumer.accept(sessionData);
        }
    }

    public boolean isAdminOf(BasicUser var1);

    public boolean isBrokerOf(BasicUser var1);

    public boolean isGlobalAdminInNetwork();

    public boolean isGuest();

    public boolean isLoggedIn();

    public boolean isManagerOf(BasicUser var1);

    public boolean isMultiNetworkAdminInGlobalMode();

    public boolean isOwnerOf(BasicUser var1);

    default public boolean isRest() {
        RequestData requestData = this.getRequestData();
        String string = requestData == null ? null : requestData.getUri();
        return string != null && string.startsWith("/api/");
    }

    public boolean isScript();

    public boolean isSelf(BasicUser var1);

    public boolean isSystem();

    public boolean isTrusted();

    public boolean isVisible(EntityCheck<SimpleEntity> var1, SimpleEntity var2);

    public boolean manages(BasicUser var1);

    public boolean relatesTo(BasicUser var1);

    public SessionData unwrap();
}

