/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.OAuthIdentityProvider;
import org.cyclos.entities.access.OidcIdentityProvider;
import org.cyclos.model.access.identityproviders.IdentityProviderType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oidc.client.AzureAdClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.AzureAdOidcConfiguration;
import org.pac4j.oidc.config.OidcConfiguration;

public class IdentityProviderClient {
    private static final String FACEBOOK_SCOPE = "email";
    private static final String FACEBOOK_FIELDS = "id,name,email";
    private static final String FACEBOOK_FULL_FIELDS = "id,picture.type(large),name,email,website";
    private final String callbackUrl;
    private final IdentityProviderType type;
    private final String internalName;
    private final String key;
    private final String secret;
    private final String discoveryUrl;
    private final boolean fullProfile;

    public IdentityProviderClient(IdentityProvider identityProvider, String string, boolean bl) {
        this.callbackUrl = string;
        this.fullProfile = bl;
        OAuthIdentityProvider oAuthIdentityProvider = (OAuthIdentityProvider)ObjectHelper.ifType((Object)identityProvider, OAuthIdentityProvider.class);
        OidcIdentityProvider oidcIdentityProvider = (OidcIdentityProvider)ObjectHelper.ifType((Object)identityProvider, OidcIdentityProvider.class);
        this.type = identityProvider.getType();
        this.internalName = identityProvider.getInternalName();
        this.key = oAuthIdentityProvider == null ? null : oAuthIdentityProvider.getClientId();
        this.secret = oAuthIdentityProvider == null ? null : oAuthIdentityProvider.getClientSecret();
        this.discoveryUrl = oidcIdentityProvider == null ? null : oidcIdentityProvider.getDiscoveryUrl();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IdentityProviderClient identityProviderClient = (IdentityProviderClient)object;
        if (this.callbackUrl == null ? identityProviderClient.callbackUrl != null : !this.callbackUrl.equals(identityProviderClient.callbackUrl)) {
            return false;
        }
        if (this.discoveryUrl == null ? identityProviderClient.discoveryUrl != null : !this.discoveryUrl.equals(identityProviderClient.discoveryUrl)) {
            return false;
        }
        if (this.fullProfile != identityProviderClient.fullProfile) {
            return false;
        }
        if (this.internalName == null ? identityProviderClient.internalName != null : !this.internalName.equals(identityProviderClient.internalName)) {
            return false;
        }
        if (this.key == null ? identityProviderClient.key != null : !this.key.equals(identityProviderClient.key)) {
            return false;
        }
        if (this.secret == null ? identityProviderClient.secret != null : !this.secret.equals(identityProviderClient.secret)) {
            return false;
        }
        return this.type == identityProviderClient.type;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.callbackUrl == null ? 0 : this.callbackUrl.hashCode());
        n = 31 * n + (this.discoveryUrl == null ? 0 : this.discoveryUrl.hashCode());
        n = 31 * n + (this.fullProfile ? 1231 : 1237);
        n = 31 * n + (this.internalName == null ? 0 : this.internalName.hashCode());
        n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
        n = 31 * n + (this.secret == null ? 0 : this.secret.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public IndirectClient newClient() {
        if (StringHelper.isBlank((Object)this.key)) {
            throw new IllegalStateException("No clientId for identity provider " + this.internalName);
        }
        LinkedIn2Client linkedIn2Client = null;
        switch (this.type) {
            case FACEBOOK: {
                FacebookClient facebookClient = new FacebookClient(this.key, this.secret);
                facebookClient.setScope(FACEBOOK_SCOPE);
                facebookClient.setFields(this.fullProfile ? FACEBOOK_FULL_FIELDS : FACEBOOK_FIELDS);
                linkedIn2Client = facebookClient;
                break;
            }
            case TWITTER: {
                linkedIn2Client = new TwitterClient(this.key, this.secret, true);
                break;
            }
            case LINKED_IN: {
                linkedIn2Client = new LinkedIn2Client(this.key, this.secret);
                break;
            }
            case MICROSOFT: {
                AzureAdOidcConfiguration azureAdOidcConfiguration = new AzureAdOidcConfiguration();
                azureAdOidcConfiguration.setClientId(this.key);
                azureAdOidcConfiguration.setSecret(this.secret);
                azureAdOidcConfiguration.setScope("openid profile email");
                azureAdOidcConfiguration.setTenant("common");
                linkedIn2Client = new AzureAdClient(azureAdOidcConfiguration);
                break;
            }
            case YAHOO: 
            case GOOGLE: 
            case OIDC: {
                if (this.discoveryUrl == null) {
                    throw new IllegalStateException("No OIDC discovery URL for identity provider " + this.internalName);
                }
                OidcConfiguration oidcConfiguration = new OidcConfiguration();
                oidcConfiguration.setClientId(this.key);
                oidcConfiguration.setSecret(this.secret);
                oidcConfiguration.setDiscoveryURI(this.discoveryUrl);
                oidcConfiguration.addCustomParam("display", "popup");
                OIDCProviderMetadata oIDCProviderMetadata = oidcConfiguration.findProviderMetadata();
                Scope scope = oIDCProviderMetadata.getScopes();
                Object object = "openid";
                if (scope != null) {
                    if (scope.contains("profile")) {
                        object = (String)object + " profile";
                    }
                    if (scope.contains(FACEBOOK_SCOPE)) {
                        object = (String)object + " email";
                    }
                    if (this.fullProfile && scope.contains("phone")) {
                        object = (String)object + " phone";
                    }
                }
                oidcConfiguration.setScope((String)object);
                linkedIn2Client = new OidcClient(oidcConfiguration);
            }
        }
        if (linkedIn2Client == null) {
            throw new IllegalStateException("Unhandled identity provider type: " + String.valueOf(this.type));
        }
        linkedIn2Client.setCallbackUrl(this.callbackUrl);
        linkedIn2Client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        linkedIn2Client.setName(this.internalName);
        return linkedIn2Client;
    }
}

