/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.messaging.alerts.SystemAlertType;

public enum FailedAction {
    BLOCKED_USER(TimeInterval.ONE_DAY, SystemAlertType.MAX_BLOCKED_USERS_REACHED, true),
    FAILED_PHONE_VERIFICATION_AS_GUEST(TimeInterval.ONE_HOUR, true),
    FAILED_EMAIL_VERIFICATION_AS_GUEST(TimeInterval.ONE_HOUR, true),
    FAILED_PRINCIPAL(TimeInterval.ONE_HOUR, SystemAlertType.MAX_INCORRECT_LOGIN_ATTEMPTS, true),
    FAILED_VOUCHER_INFO(TimeInterval.ONE_DAY, true),
    FORGOT_PASSWORD_REQUEST(TimeInterval.ONE_HOUR, true),
    FAILED_ACCESS_CLIENT_ACTIVATION(TimeInterval.ONE_DAY, false),
    FAILED_TOKEN_ACTIVATION(TimeInterval.ONE_DAY, false),
    FAILED_SECURITY_ANSWER(TimeInterval.ONE_DAY, false),
    FAILED_VOUCHER_REDEEM(TimeInterval.ONE_DAY, false),
    FAILED_USER_LOCATION(TimeInterval.ONE_DAY, false),
    FAILED_DEVICE_CONFIRMATION(TimeInterval.ONE_DAY, false),
    FAILED_DEVICE_ACTIVATION(TimeInterval.ONE_DAY, false),
    FAILED_VOUCHER_PIN(TimeInterval.ONE_DAY, false),
    FAILED_PHONE_VERIFICATION(TimeInterval.ONE_HOUR, false),
    FAILED_TOTP(TimeInterval.ONE_DAY, false),
    FAILED_TOTP_ACTIVATION(TimeInterval.ONE_DAY, false);

    private SystemAlertType alertType;
    private boolean forGuest;
    private TimeInterval countInterval;

    private FailedAction(TimeInterval timeInterval, boolean bl) {
        this.countInterval = timeInterval;
        this.forGuest = bl;
    }

    private FailedAction(TimeInterval timeInterval, SystemAlertType systemAlertType, boolean bl) {
        this(timeInterval, bl);
        this.alertType = systemAlertType;
    }

    public boolean isForGuest() {
        return this.forGuest;
    }

    SystemAlertType alertType() {
        return this.alertType;
    }

    TimeInterval countInterval() {
        return this.countInterval;
    }
}

