/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.EnumSet;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.UserPrincipals;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UrgentSituation;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.model.access.RequestData;
import org.cyclos.utils.CollectionHelper;

public class DirectUserSessionData
extends UserSessionData {
    private final UserPrincipal userPrincipal;
    private final String channelName;
    private final String accessChannelName;
    private EnumSet<UrgentSituation> honorUrgentSituations;
    private Pin pin;
    private IdentityProvider identityProvider;
    private Session session;

    protected DirectUserSessionData(BasicUser basicUser, SessionData sessionData) {
        this(sessionData.getChannelName(), sessionData.getAccessChannelName(), UserPrincipals.username((BasicUser)basicUser), null, null, null, sessionData.getRequestData(), null);
    }

    DirectUserSessionData(String string, String string2, UserPrincipal userPrincipal, Pin pin, IdentityProvider identityProvider, Session session, RequestData requestData, EnumSet<UrgentSituation> enumSet) {
        super(requestData);
        this.userPrincipal = userPrincipal;
        this.pin = pin;
        this.identityProvider = identityProvider;
        this.channelName = string;
        this.accessChannelName = string2;
        this.session = session;
        this.honorUrgentSituations = CollectionHelper.isEmpty(enumSet) ? EnumSet.noneOf(UrgentSituation.class) : EnumSet.copyOf(enumSet);
    }

    @Override
    public String getAccessChannelName() {
        return this.accessChannelName;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    @Override
    public Pin getPin() {
        return this.pin;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    protected Long doGetLoggedBasicUserId() {
        return this.userPrincipal.getBasicUser().getId();
    }

    @Override
    protected UserPrincipal doGetUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    protected boolean doHasExpiredPassword() {
        return this.honorUrgentSituations.contains((Object)UrgentSituation.EXPIRED_PASSWORD) && super.doHasExpiredPassword();
    }

    @Override
    protected boolean doHasPendingAgreements(ProductsAccessor productsAccessor) {
        return this.honorUrgentSituations.contains((Object)UrgentSituation.PENDING_AGREEMENT) && super.doHasPendingAgreements(productsAccessor);
    }

    @Override
    protected boolean fallbackToDefaultLocales() {
        return false;
    }

    @Override
    protected boolean requiresLoginConfirmation(CredentialsConfiguration credentialsConfiguration) {
        return this.honorUrgentSituations.contains((Object)UrgentSituation.LOGIN_CONFIRMATION) && super.requiresLoginConfirmation(credentialsConfiguration);
    }

    @Override
    protected ProductsAccessor resolveProductsAccessor(ProductsHandler productsHandler) {
        if (!this.honorUrgentSituations.isEmpty()) {
            return super.resolveProductsAccessor(productsHandler);
        }
        return productsHandler.getAccessor(this.getLoggedBasicUser(), null, null);
    }
}

