/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.principaltypes.MemberAccessClientPermission;

public class AccessClientSessionData
extends UserSessionData {
    private static final Set<Permission> ALL_PERMISSIONS = EnumSet.allOf(Permission.class);
    private static final Set<Permission> RECEIVE_AND_MAKE_PERMISSIONS;
    private static final Set<Permission> RECEIVE_PERMISSIONS;
    private static final Map<MemberAccessClientPermission, Set<Permission>> MAPPING;
    private final String channelName;
    private final String accessClientToken;
    private MemberAccessClientPermission typePermission;
    private boolean forLogin;
    private AccessClient accessClient;

    AccessClientSessionData(boolean bl, String string, String string2, RequestData requestData) {
        super(requestData);
        this.forLogin = bl;
        this.channelName = string;
        this.accessClientToken = string2;
    }

    @Override
    public String getAccessChannelName() {
        return this.getChannelName();
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public Pin getPin() {
        return null;
    }

    @Override
    protected Long doGetLoggedBasicUserId() {
        return this.getAccessClient().getUser().getId();
    }

    @Override
    protected UserPrincipal doGetUserPrincipal() {
        if (this.accessClient == null) {
            this.accessClient = this.runAsSystem(() -> {
                SessionHandler sessionHandler = InvocationContext.bean(SessionHandler.class);
                return sessionHandler.checkAccessClientAccess(this.forLogin, this.getNetwork(), this.channelName, this.getRemoteAddress(), this.accessClientToken);
            });
        }
        return this.accessClient;
    }

    @Override
    protected boolean doHasExpiredPassword() {
        return false;
    }

    @Override
    protected boolean doHasPendingAgreements(ProductsAccessor productsAccessor) {
        return false;
    }

    @Override
    protected boolean doHasPermission(Permission permission) {
        Set<Permission> set;
        if (this.typePermission == null) {
            this.typePermission = super.doHasPendingAgreements(this.getProducts()) ? MemberAccessClientPermission.RECEIVE_PAYMENT : this.getAccessClient().getType().getPermission();
        }
        return (set = MAPPING.get(this.typePermission)) != null && set.contains(permission) && super.doHasPermission(permission);
    }

    @Override
    protected boolean requiresLoginConfirmation(CredentialsConfiguration credentialsConfiguration) {
        return false;
    }

    static {
        RECEIVE_PERMISSIONS = EnumSet.of(Permission.MY_PAYMENTS_RECEIVE, new Permission[]{Permission.MY_AUTHORIZED_PAYMENTS_VIEW, Permission.MY_PAYMENT_TICKETS_VIEW, Permission.MY_PAYMENT_TICKETS_CREATE, Permission.MY_SCHEDULED_PAYMENTS_VIEW, Permission.MY_PAYMENT_REQUESTS_VIEW, Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER, Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM, Permission.MY_VOUCHERS_REDEEM, Permission.MY_VOUCHERS_VIEW_TRANSACTIONS, Permission.USER_VISIBILITY_SEARCH});
        RECEIVE_AND_MAKE_PERMISSIONS = EnumSet.copyOf(RECEIVE_PERMISSIONS);
        RECEIVE_AND_MAKE_PERMISSIONS.addAll(EnumSet.of(Permission.MY_EXTERNAL_PAYMENTS_VIEW, new Permission[]{Permission.MY_PAYMENT_TICKETS_APPROVE, Permission.MY_PAYMENTS_PAY_TO_USER, Permission.MY_PAYMENTS_PAY_TO_SYSTEM, Permission.MY_EXTERNAL_PAYMENTS_PAY_TO_USER, Permission.MY_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT, Permission.MY_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT}));
        MAPPING = new EnumMap<MemberAccessClientPermission, Set<Permission>>(MemberAccessClientPermission.class);
        MAPPING.put(MemberAccessClientPermission.ALL, ALL_PERMISSIONS);
        MAPPING.put(MemberAccessClientPermission.RECEIVE_AND_MAKE_PAYMENT, RECEIVE_AND_MAKE_PERMISSIONS);
        MAPPING.put(MemberAccessClientPermission.RECEIVE_PAYMENT, RECEIVE_PERMISSIONS);
    }
}

