/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.Property;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.Pair;

public class TablePropertyLogDescriptor<R extends EntityDTO, B extends Bean>
extends PropertyLogDescriptor<B> {
    private PropertyAccess rowIdAccess;
    private Comparator<?> rowComparator;
    private Class<R> rowBeanClass;
    private Map<PropertyAccess, Pair<Object, Boolean>> columns = new LinkedHashMap<PropertyAccess, Pair<Object, Boolean>>();
    private Set<String> missingColProperties = new HashSet<String>();
    private PropertyAccess nestedTableAccess;
    private PropertyAccess nestedRowIdAccess;

    public TablePropertyLogDescriptor(EntityLogDescriptor<B> entityLogDescriptor, PropertyAccess propertyAccess) {
        super(entityLogDescriptor, propertyAccess);
    }

    @Override
    public EntityLogDescriptor<B> add() {
        if (!this.missingColProperties.isEmpty()) {
            throw new IllegalStateException(String.format("Entity log error: the table property '%s.%s' is not mapped correctly. The following columns aren't mapped / ignored: %s", this.rowBeanClass.getName(), this.rowIdAccess.getPropertyName(), this.missingColProperties));
        }
        return super.add();
    }

    public TablePropertyLogDescriptor<R, B> col(Property<Boolean, ? super R> property, Object object) {
        return this.col(property, object, false);
    }

    public TablePropertyLogDescriptor<R, B> col(Property<Boolean, ? super R> property, Object object, boolean bl) {
        this.columns.put(this.logDescriptor.toAccess(property), (Pair<Object, Boolean>)Pair.create((Object)object, (Object)bl));
        this.ignore(property);
        return this;
    }

    public Iterable<Pair<PropertyAccess, Object>> columns() {
        return () -> this.columns.entrySet().stream().map(entry -> Pair.create((Object)((PropertyAccess)entry.getKey()), (Object)((Pair)entry.getValue()).getFirst())).iterator();
    }

    public TablePropertyLogDescriptor<?, R> getNestedTableDescriptor() {
        if (this.nestedTableAccess == null) {
            return null;
        }
        TablePropertyLogDescriptor<R, B> tablePropertyLogDescriptor = new TablePropertyLogDescriptor<R, B>(this.logDescriptor, this.nestedTableAccess);
        tablePropertyLogDescriptor.rowIdAccess = this.nestedRowIdAccess;
        tablePropertyLogDescriptor.columns = this.columns.entrySet().stream().filter(entry -> (Boolean)((Pair)entry.getValue()).getSecond()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (pair, pair2) -> pair2, LinkedHashMap::new));
        return tablePropertyLogDescriptor;
    }

    public Comparator<?> getRowComparator() {
        return this.rowComparator;
    }

    public PropertyAccess getRowIdAccess() {
        return this.rowIdAccess;
    }

    public TablePropertyLogDescriptor<R, B> ignore(Property<?, ? super R> property) {
        this.missingColProperties.remove(property.getName());
        return this;
    }

    @Override
    public boolean isTable() {
        return true;
    }

    public TablePropertyLogDescriptor<R, B> label(Object object) {
        return (TablePropertyLogDescriptor)super.label(object);
    }

    public TablePropertyLogDescriptor<R, B> nestedRow(CollectionPathBase<?, ?, ?> collectionPathBase, Path<?> path) {
        this.nestedTableAccess = this.logDescriptor.toAccess((Path<?>)collectionPathBase);
        this.nestedRowIdAccess = this.logDescriptor.toAccess(path);
        return this;
    }

    public TablePropertyLogDescriptor<R, B> row(Class<R> clazz, Property<?, ? super R> property) {
        return this.row(clazz, property, null);
    }

    public TablePropertyLogDescriptor<R, B> row(Class<R> clazz, Property<?, ? super R> property, Comparator<?> comparator) {
        this.rowComparator = comparator;
        this.rowBeanClass = clazz;
        EntityDTO entityDTO = (EntityDTO)ClassHelper.instantiate(clazz);
        this.missingColProperties.addAll(entityDTO.propertyMap().keySet());
        this.missingColProperties.remove(property.getName());
        this.logDescriptor.defaultIgnore(this.missingColProperties);
        this.rowIdAccess = this.logDescriptor.toAccess(property);
        return this;
    }
}

