/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import java.io.File;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingEvent;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.utils.Pair;

public class RequestContext {
    private static final ThreadLocal<RequestContext> CURRENT = new ThreadLocal();
    private static final Logger LOG = LogManager.getLogger(RequestContext.class);
    private StartProfilingParams profilingParams;
    private ProfilingEntry profilingEntry;
    private Set<Object> sensitiveQueryParamValues;
    private Set<File> registerdFiles;

    public static <E extends ProfilingEvent> E addProfilingEvent(Function<StartProfilingParams, E> function) {
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null || requestContext.profilingEntry == null || requestContext.profilingParams == null) {
            return null;
        }
        ProfilingEvent profilingEvent = (ProfilingEvent)function.apply(requestContext.profilingParams);
        requestContext.profilingEntry.addEvent(profilingEvent);
        return (E)profilingEvent;
    }

    public static void addSensitiveQueryParamValue(Object object) {
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null || requestContext.profilingEntry == null || requestContext.profilingParams == null) {
            return;
        }
        if (requestContext.sensitiveQueryParamValues == null) {
            requestContext.sensitiveQueryParamValues = new HashSet<Object>();
        }
        requestContext.sensitiveQueryParamValues.add(object);
    }

    public static RequestContext ensure() {
        RequestContext requestContext = CURRENT.get();
        if (requestContext == null) {
            requestContext = new RequestContext();
            CURRENT.set(requestContext);
        }
        return requestContext;
    }

    public static RequestContext get() {
        return CURRENT.get();
    }

    public static void remove() {
        RequestContext requestContext = CURRENT.get();
        CURRENT.remove();
        if (requestContext != null) {
            requestContext.removeRegisteredFiles();
        }
    }

    private RequestContext() {
    }

    public ProfilingEntry getProfilingEntry() {
        return this.profilingEntry;
    }

    public StartProfilingParams getProfilingParams() {
        return this.profilingParams;
    }

    public boolean isSensitiveQueryParamValue(Object object) {
        return this.sensitiveQueryParamValues != null && this.sensitiveQueryParamValues.contains(object);
    }

    public void registerFile(File file) {
        if (this.registerdFiles == null) {
            this.registerdFiles = new HashSet<File>();
        }
        this.registerdFiles.add(file);
    }

    public void setProfiling(Pair<StartProfilingParams, ProfilingEntry> pair) {
        if (pair == null) {
            this.profilingParams = null;
            this.profilingEntry = null;
        } else {
            this.profilingParams = (StartProfilingParams)pair.getFirst();
            this.profilingEntry = (ProfilingEntry)pair.getSecond();
        }
    }

    private void removeRegisteredFiles() {
        if (this.registerdFiles != null) {
            for (File file : this.registerdFiles) {
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (Exception exception) {
                    LOG.error("Error removing file: " + file.getPath());
                }
            }
            this.registerdFiles = null;
        }
    }
}

