package v4_12

import org.cyclos.entities.banking.QVoucher
import org.cyclos.impl.banking.AccountServiceLocal
import org.cyclos.impl.utils.QueryHelper
import org.cyclos.impl.utils.persistence.DBQuery
import org.cyclos.impl.utils.persistence.EntityManagerHandler
import org.cyclos.model.banking.vouchers.VoucherStatus

import groovy.transform.Field
import groovy.transform.TypeChecked

@Field AccountServiceLocal accountService = binding.getVariable('accountService') as AccountServiceLocal
@Field EntityManagerHandler entityManagerHandler = binding.getVariable('entityManagerHandler') as EntityManagerHandler

@TypeChecked
void returnMissingAmounts() {
    QVoucher v = QVoucher.voucher
    DBQuery query = (DBQuery) entityManagerHandler
        .from(v)
        .where(v.pack().buyer().isNull(),
        v.pack().amountReservations.isNotEmpty(),
        v.amountDereservations.isEmpty(),
        v.status.notIn([
            VoucherStatus.OPEN,
            VoucherStatus.PENDING
        ]))
    QueryHelper.processBatch(entityManagerHandler, query.iterate(v)) {
        println("Processing voucher ${it}")
        accountService.dereserveAmountIfNeeded(it)
    }
}

// Run the migration
returnMissingAmounts()
