package v4_12

import java.sql.ResultSet

import org.cyclos.entities.system.Language
import org.cyclos.entities.system.Network
import org.cyclos.entities.users.BasicUser
import org.cyclos.impl.access.ConfigurationHandler
import org.cyclos.impl.contentmanagement.TranslationHandler
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler
import org.cyclos.model.system.SystemKeys
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.jdbc.core.RowCallbackHandler

import groovy.transform.TypeChecked

// Translate "Created"
@TypeChecked
def translate(Language lang) {
    def bundle = (binding.variables.translationHandler as TranslationHandler).getResourceBundle(lang)
    bundle.getString(SystemKeys.EntityLogs.ENTITY_CREATED.fullKey())
}

@TypeChecked
def Language findLang(Long byId, Long netId) {
    def remh = binding.variables.rawEntityManagerHandler as RawEntityManagerHandler
    def configurationHandler = binding.variables.configurationHandler as ConfigurationHandler
    if (!byId) {
        if (!netId) {
            return configurationHandler.getGlobalDefault().getDefaultLanguage()
        } else {
            return configurationHandler.getAccessor(remh.find(Network, netId)).getDefaultLanguage()
        }
    } else {
        return configurationHandler.getAccessor(remh.find(BasicUser, byId)).getDefaultLanguage()
    }
}

@TypeChecked
def fixEntityLogsMigration() {
    def toFixQuery = '''
		SELECT epl.id, epl.name as epl_Name,
		el.date, el.name, el.type, el.network_id, el.by_id
		FROM entity_logs el join entity_property_logs epl on el.id=epl.entity_log_id
		WHERE el.event = 'CREATE' and epl.new_value is not null
		ORDER BY el.date desc
		'''
    def updateQuery = '''
		UPDATE entity_property_logs set
			old_value = null,
			new_value = null,
			custom_field_id = null,
			property_name = null,
			order_index = 0,
			name = ?
		WHERE id = ?
		'''
    def jdbc = binding.variables.jdbc as JdbcTemplate
    jdbc.query(toFixQuery, {ResultSet r ->
        def lang = findLang(r.getLong('by_id'), r.getLong('network_id'))
        def created = translate(lang)
        jdbc.update(updateQuery, created, r.getLong('id'))
    } as RowCallbackHandler)
}

// Run the migration
fixEntityLogsMigration()
