/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation;

import com.google.api.pathtemplate.ValidationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.utils.RestBeanPropertyMapping;
import org.cyclos.impl.utils.validation.ValidationHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Bean;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidationHandlerImpl
extends BaseGlobalHandlerImpl
implements ValidationHandler {
    private static final String ALREADY_VALIDATED = "alreadyValidated";
    private static final String VALIDATED_KEYS = "validatedKeys";
    @Autowired
    private RestBeanPropertyMapping restBeanPropertyMapping;

    public void addValidatedKey(Bean bean, String string) {
        HashSet<String> hashSet = (HashSet<String>)bean.getAttribute(VALIDATED_KEYS);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            hashSet.add(string);
            bean.setAttribute(VALIDATED_KEYS, hashSet);
        } else {
            hashSet.add(string);
        }
    }

    public void clearAlreadyValidated(Bean bean) {
        bean.removeAttribute(ALREADY_VALIDATED);
    }

    public boolean isAlreadyValidated(Bean bean) {
        return Boolean.TRUE.equals(bean.getAttribute(ALREADY_VALIDATED));
    }

    public boolean isAlreadyValidated(Bean bean, String string) {
        return CollectionHelper.containsAny((Collection)((Set)bean.getAttribute(VALIDATED_KEYS)), (Object[])new Object[]{string});
    }

    public void setAlreadyValidated(Bean bean, boolean bl) {
        bean.setAttribute(ALREADY_VALIDATED, (Object)bl);
    }

    public void validate(Validator validator, Object object) throws ValidationException {
        Bean bean;
        if (object instanceof Bean && this.isAlreadyValidated(bean = (Bean)object)) {
            return;
        }
        validator.validate(this.restBeanPropertyMapping, this.getFormatter(), object);
        if (object instanceof Bean) {
            bean = (Bean)object;
            this.setAlreadyValidated(bean, true);
        }
    }

    public void validate(Validator validator, Object object, String string) throws ValidationException {
        Bean bean;
        if (object instanceof Bean && this.isAlreadyValidated(bean = (Bean)object, string)) {
            return;
        }
        validator.validate(this.restBeanPropertyMapping, this.getFormatter(), object);
        if (object instanceof Bean) {
            this.addValidatedKey((Bean)object, string);
        }
    }
}

