/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.transaction;

import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ProfilingTransactionEndEvent;
import org.cyclos.impl.system.ProfilingTransactionStartEvent;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.transaction.TransactionHandler;
import org.cyclos.model.RetryException;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.proxy.UndeclaredThrowableException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;

@Component
public class TransactionHandlerImpl
implements TransactionHandler {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    private DefaultTransactionDefinition inTransactionDefinition;
    private DefaultTransactionDefinition autocommitTransactionDefinition;
    private boolean shouldFlushTransaction;

    @PostConstruct
    public void initialize() {
        this.inTransactionDefinition = new DefaultTransactionDefinition();
        this.autocommitTransactionDefinition = new DefaultTransactionDefinition();
        this.autocommitTransactionDefinition.setReadOnly(true);
        this.shouldFlushTransaction = false;
    }

    public <T> Pair<T, Boolean> run(TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback, int n) {
        return this.run(InvocationContext.get(), transactionLevel, transactionCallback, n);
    }

    public void setShouldFlushTransaction(boolean bl) {
        this.shouldFlushTransaction = bl;
    }

    private void commit(TransactionStatus transactionStatus) {
        if (transactionStatus.isRollbackOnly()) {
            this.rollback(transactionStatus);
        } else {
            this.transactionManager.commit(transactionStatus);
        }
    }

    private <T> Pair<T, Boolean> doRun(InvocationContext invocationContext, TransactionLevel transactionLevel, TransactionDefinition transactionDefinition, TransactionCallback<T> transactionCallback, int n) {
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(transactionDefinition);
        if (!transactionDefinition.isReadOnly() && transactionLevel.isReadOnly()) {
            transactionStatus.setRollbackOnly();
        }
        ProfilingTransactionStartEvent profilingTransactionStartEvent = (ProfilingTransactionStartEvent)RequestContext.addProfilingEvent(startProfilingParams -> new ProfilingTransactionStartEvent(transactionLevel, Integer.valueOf(n)));
        MutableObject mutableObject = new MutableObject();
        MutableObject mutableObject2 = new MutableObject();
        try {
            T t = this.runEnsuringInvocationContext(invocationContext, transactionLevel, transactionCallback, transactionStatus);
            if (this.cyclosProperties.isForceFlushOnEveryTransaction() && !transactionStatus.isRollbackOnly()) {
                transactionStatus.flush();
            }
            if (transactionLevel.isReadOnly() && invocationContext.hasWrite()) {
                throw new UnexpectedDataAccessException("A read-only transaction attempted to write on database");
            }
            Boolean bl = transactionLevel.isReadOnly() ? null : Boolean.valueOf(!transactionStatus.isRollbackOnly());
            this.commit(transactionStatus);
            mutableObject.set((Object)bl);
            Pair pair = Pair.create(t, (Object)bl);
            return pair;
        }
        catch (Exception exception) {
            this.rollback(transactionStatus);
            mutableObject.set((Object)false);
            try {
                this.nativeQueryHandler.retryIfConnectionError(exception);
                if (transactionLevel.isReadOnly() && this.cyclosProperties.isUseReadOnlyDataSource()) {
                    RetryException retryException = new RetryException("Transaction failed in read-only connection. Retry in read-write.", (Throwable)exception);
                    retryException.setRequiredLevel(TransactionLevel.READ_WRITE);
                    throw retryException;
                }
                throw exception;
            }
            catch (Exception exception2) {
                mutableObject2.set((Object)exception2);
                throw exception2 instanceof RuntimeException ? (RuntimeException)exception2 : new UndeclaredThrowableException((Throwable)exception2);
            }
        }
        finally {
            if (profilingTransactionStartEvent != null) {
                RequestContext.addProfilingEvent(startProfilingParams -> new ProfilingTransactionEndEvent(profilingTransactionStartEvent, (Boolean)mutableObject.get(), (Throwable)mutableObject2.get()));
            }
        }
    }

    private void rollback(TransactionStatus transactionStatus) {
        try {
            if (!transactionStatus.isCompleted()) {
                this.transactionManager.rollback(transactionStatus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <T> Pair<T, Boolean> run(InvocationContext invocationContext, TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback, int n) {
        DefaultTransactionDefinition defaultTransactionDefinition;
        switch (transactionLevel) {
            case READ_ONLY: {
                defaultTransactionDefinition = this.autocommitTransactionDefinition;
                break;
            }
            case READ_ONLY_TRANSACTION: {
                if (this.nativeQueryHandler.supportsBlobsInReadOnlyTransactions() || !this.storedFileHandler.isStoredOnDB()) {
                    defaultTransactionDefinition = this.autocommitTransactionDefinition;
                    break;
                }
                defaultTransactionDefinition = this.inTransactionDefinition;
                break;
            }
            case READ_WRITE: {
                defaultTransactionDefinition = this.inTransactionDefinition;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled transaction level: " + String.valueOf(transactionLevel));
            }
        }
        return this.doRun(invocationContext, transactionLevel, (TransactionDefinition)defaultTransactionDefinition, transactionCallback, n);
    }

    private <T> T runEnsuringInvocationContext(InvocationContext invocationContext, TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback, TransactionStatus transactionStatus) {
        if (invocationContext != null && invocationContext.getEntityManager() != null) {
            throw new UnexpectedDataAccessException("There is already a transaction bound to this thread");
        }
        EntityManager entityManager = this.rawEntityManagerHandler.getEntityManager();
        if (invocationContext != null) {
            invocationContext.setEntityManager(entityManager);
            invocationContext.setTransactionLevel(transactionLevel);
            invocationContext.setTransactionStatus(transactionStatus);
        }
        try {
            Object object = transactionCallback.doInTransaction(transactionStatus);
            invocationContext.releaseWithinTransaction();
            if (transactionLevel == TransactionLevel.READ_WRITE) {
                if (this.shouldFlushTransaction || !transactionStatus.isRollbackOnly()) {
                    entityManager.flush();
                }
                entityManager.clear();
            }
            Object object2 = object;
            return (T)object2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        finally {
            if (invocationContext != null) {
                invocationContext.setEntityManager(null);
                invocationContext.setTransactionLevel(null);
                invocationContext.setTransactionStatus(null);
            }
        }
    }
}

