/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.thymeleaf;

import java.util.MissingResourceException;
import javax.annotation.PostConstruct;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.thymeleaf.ThymeleafExpressionObjects;
import org.cyclos.utils.MessageFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardConversionService;

public abstract class BaseThymeleafTemplateEngine
extends TemplateEngine {
    @Autowired
    private TranslationHandler translationHandler;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private ThymeleafExpressionObjects thymeleafExpressionObjects;

    @PostConstruct
    public final void postConstruct() {
        IStandardConversionService iStandardConversionService = new IStandardConversionService(){

            public <T> T convert(IExpressionContext iExpressionContext, Object object, Class<T> clazz) {
                if (clazz.equals(String.class)) {
                    InvocationContext invocationContext = InvocationContext.get();
                    ConfigurationAccessor configurationAccessor = invocationContext.sessionData().getConfiguration();
                    return (T)invocationContext.formatter(configurationAccessor).format(object);
                }
                return (T)BaseThymeleafTemplateEngine.this.conversionHandler.convert(clazz, object);
            }
        };
        StandardDialect standardDialect = new StandardDialect();
        standardDialect.setConversionService(iStandardConversionService);
        this.setDialect((IDialect)standardDialect);
        this.addDialect((IDialect)this.thymeleafExpressionObjects);
        this.setMessageResolver((IMessageResolver)new AbstractMessageResolver(){

            public String createAbsentMessageRepresentation(ITemplateContext iTemplateContext, Class<?> clazz, String string, Object[] objectArray) {
                return "???" + string + "???";
            }

            public String resolveMessage(ITemplateContext iTemplateContext, Class<?> clazz, String string, Object[] objectArray) {
                try {
                    return BaseThymeleafTemplateEngine.this.translationHandler.getResourceBundle().message(string, MessageFormat.HTML, objectArray);
                }
                catch (MissingResourceException missingResourceException) {
                    return null;
                }
            }
        });
        this.doInitialize();
    }

    protected abstract void doInitialize();
}

