/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.OptimisticLockException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.utils.tasks.AbstractRecurringTask;
import org.cyclos.model.IEntity;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;

public abstract class EntityBatchRecurringTask<E extends IEntity>
extends AbstractRecurringTask {
    public static final int BATCH_SIZE = 200;
    private static final int MAX_ERRORS_WITH_FULL_STACK = 10;
    private static final int PARTIAL_STACK_LINES = 5;
    protected final Class<E> entityType;

    public EntityBatchRecurringTask(Class<E> clazz) {
        this.entityType = clazz;
    }

    protected boolean doLogProcessingErrors(E e, Throwable throwable) {
        return true;
    }

    @Override
    protected final void doRun() {
        Pair<Long, Throwable> pair;
        boolean bl;
        if (!this.shouldRun()) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = 0L;
        HashSet<Long> hashSet = new HashSet<Long>();
        HashMap<Long, List<Throwable>> hashMap = new HashMap<Long, List<Throwable>>();
        block2: do {
            bl = false;
            Collection<Long> collection = this.doGetNextIds();
            if (!CollectionHelper.isNotEmpty(collection)) continue;
            for (Long l3 : collection) {
                if (!hashSet.add(l3)) continue;
                bl |= true;
                pair = this.doProcessAndFinish(l3);
                Throwable throwable = (Throwable)pair.getSecond();
                if (throwable instanceof InterruptedException) continue block2;
                if (throwable == null) {
                    ++l2;
                    continue;
                }
                this.logTaskError(null, throwable);
                if (!this.shouldGenerateErrorLog((Long)pair.getFirst(), throwable)) continue;
                this.addError((Long)pair.getFirst(), throwable, hashMap);
            }
        } while (bl);
        this.generateErrorLogs(hashMap);
        Throwable throwable = (Throwable)CollectionHelper.first((Iterable)((Iterable)CollectionHelper.first(hashMap.values())));
        if (throwable != null) {
            Long l3;
            l3 = RequestContext.get();
            Pair<Long, Throwable> pair2 = pair = l3 == null ? null : l3.getProfilingEntry();
            if (pair != null) {
                pair.setErrorTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }
        long l4 = System.currentTimeMillis() - l;
        this.logTaskSuccess(null, l4, l2);
        try {
            this.onFinish();
        }
        catch (Exception exception) {
            this.getLogger().warn("Error when running the onFinish() callback", (Throwable)exception);
        }
    }

    protected boolean doShouldGenerateErrorLog(Long l, Throwable throwable) {
        return true;
    }

    protected E find(Long l) {
        return this.find(this.entityType, l);
    }

    protected abstract void finish(E var1, Throwable var2) throws Throwable;

    protected final void generateErrorLog(Long l, String string) {
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            if (l == null) {
                this.errorLogService.create(this.getName(), null, string, null, null);
            } else {
                Network network = this.find(Network.class, l);
                this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> {
                    this.errorLogService.create(this.getName(), null, string, null, null);
                    return null;
                });
            }
            return null;
        });
    }

    protected final void generateErrorLog(Long l, Throwable throwable) {
        this.generateErrorLog(l, ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    protected abstract Collection<Long> nextIds() throws Throwable;

    protected void onFinish() {
    }

    protected abstract void process(E var1) throws Throwable;

    protected Network resolveNetwork(E e) {
        if (e instanceof NetworkedEntity) {
            return ((NetworkedEntity)e).getNetwork();
        }
        return null;
    }

    @Override
    protected final boolean shouldGenerateErrorLog() {
        return false;
    }

    protected boolean shouldRun() {
        return true;
    }

    protected boolean shouldSkipFinish(Long l, Throwable throwable) {
        return false;
    }

    private void addError(Long l, Throwable throwable, Map<Long, List<Throwable>> map) {
        List<Throwable> list = map.get(l);
        if (list == null) {
            list = new ArrayList<Throwable>();
            map.put(l, list);
        }
        list.add(throwable);
    }

    private Collection<Long> doGetNextIds() {
        return (Collection)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            try {
                Collection<Long> collection = this.nextIds();
                this.getLogger().debug("Ids \"{}\" to be processed by {}", collection, (Object)this);
                return collection;
            }
            catch (Throwable throwable) {
                this.getLogger().warn("Error acquiring the next entity identifiers to process by recurring task " + String.valueOf(this), throwable);
                return null;
            }
        });
    }

    private Pair<Long, Throwable> doProcessAndFinish(Long l) {
        Pair pair = (Pair)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            IEntity iEntity = null;
            Long l2 = null;
            Throwable throwable = null;
            try {
                iEntity = (IEntity)this.find(l);
                Network network = this.resolveNetwork(iEntity);
                l2 = SimpleEntity.id((SimpleEntity)network);
                if (network != null) {
                    IEntity iEntity2 = iEntity;
                    this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> {
                        try {
                            this.process(iEntity2);
                            return null;
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        catch (Throwable throwable) {
                            throw new InvocationTargetException(throwable);
                        }
                    });
                } else {
                    this.process(iEntity);
                }
                this.getLogger().debug("Entity \"{}\" successfully processed by {}", iEntity, (Object)this);
            }
            catch (Throwable throwable2) {
                throwable = throwable2 instanceof InvocationTargetException ? ((InvocationTargetException)throwable2).getTargetException() : throwable2;
                transactionStatus.setRollbackOnly();
                if (this.logProcessingErrors(iEntity, throwable2)) {
                    this.getLogger().warn("Error when " + String.valueOf(this) + " would mark the given entity as processed: " + String.valueOf(iEntity), throwable2);
                }
                this.getLogger().debug("Error when " + String.valueOf(this) + " would mark the given entity as processed: " + String.valueOf(iEntity), throwable2);
            }
            return Pair.create((Object)l2, (Object)throwable);
        });
        Throwable throwable = (Throwable)pair.getSecond();
        if (throwable instanceof InterruptedException) {
            return pair;
        }
        if (!this.shouldSkipFinish(l, throwable)) {
            this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                IEntity iEntity = null;
                try {
                    iEntity = (IEntity)this.find(l);
                    Long l2 = (Long)pair.getFirst();
                    if (l2 != null) {
                        IEntity iEntity2 = iEntity;
                        this.invokerHandler.runAs(SessionDataFactory.system((Network)this.find(Network.class, l2)), () -> {
                            try {
                                this.finish(iEntity2, throwable);
                                return null;
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                            catch (Throwable throwable2) {
                                throw new InvocationTargetException(throwable2);
                            }
                        });
                    } else {
                        this.finish(iEntity, throwable);
                    }
                    this.getLogger().debug("Processing of entity \"{}\" successfully finished by {}", iEntity, (Object)this);
                }
                catch (Throwable throwable2) {
                    transactionStatus.setRollbackOnly();
                    this.getLogger().error("Error when " + String.valueOf(this) + " would mark the given entity as processed: " + String.valueOf(iEntity), throwable2);
                }
                return null;
            });
        }
        return pair;
    }

    private void generateErrorLogs(Map<Long, List<Throwable>> map) {
        map.entrySet().stream().forEach(entry -> {
            MutableObject mutableObject = new MutableObject((Object)0);
            Function<String, String> function = string -> {
                mutableObject.setValue((Object)((Integer)mutableObject.getValue() + 1));
                return String.format("Error #%d --------------------%n%s", mutableObject.getValue(), string);
            };
            List list = (List)entry.getValue();
            Stream<String> stream = list.size() <= 10 ? list.stream().map(ExceptionUtils::getStackTrace) : list.stream().map(ExceptionUtils::getStackFrames).map(stringArray -> (String[])ArrayUtils.subarray((Object[])stringArray, (int)0, (int)Math.min(((String[])stringArray).length, 5))).map(stringArray -> StringUtils.join((Object[])stringArray, (String)System.lineSeparator()));
            String string2 = stream.map(function).collect(Collectors.joining(System.lineSeparator()));
            this.generateErrorLog((Long)entry.getKey(), "Errors generated: " + String.valueOf(mutableObject.getValue()) + System.lineSeparator() + string2);
        });
    }

    private boolean logProcessingErrors(E e, Throwable throwable) {
        return ExceptionHelper.findCause((Throwable)throwable, OptimisticLockException.class) instanceof OptimisticLockException ? false : this.doLogProcessingErrors(e, throwable);
    }

    private boolean shouldGenerateErrorLog(Long l, Throwable throwable) {
        return ExceptionHelper.findCause((Throwable)throwable, OptimisticLockException.class) instanceof OptimisticLockException ? false : this.doShouldGenerateErrorLog(l, throwable);
    }
}

