/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.utils.QBackgroundTaskExecution;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.search.IndexEntitiesBackgroundTask;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.AbstractRecurringTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionContext;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackgroundTaskExecutionRecurringTask
extends AbstractRecurringTask {
    private static final QBackgroundTaskExecution $ = QBackgroundTaskExecution.backgroundTaskExecution;
    private static final int BATCH_SIZE = 200;
    private static final int RESCHEDULE_TIMEOUT_MINUTES = 1;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ClusterHandler clusterHandler;
    @Autowired
    protected CyclosProperties cyclosProperties;

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NOW;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.BACKGROUND_TASK_EXECUTION;
    }

    @Override
    public String getNotesForLogging() {
        return String.format("Using %d workers", this.cyclosProperties.getMaxBackgroundTasks());
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_MINUTE;
    }

    @Override
    protected void doRun() {
        boolean bl = true;
        while (bl) {
            ClusterHandler.FinishedExecutionsHandler finishedExecutionsHandler = this.clusterHandler.getFinishedBackgroundTaskExecutions().remove();
            bl = (Boolean)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                InvocationContext invocationContext = InvocationContext.ensure();
                List<BackgroundTaskExecutionContext> list = this.nextBatch(finishedExecutionsHandler.update().ids());
                if (list.isEmpty()) {
                    return false;
                }
                this.updateSubmission(list);
                invocationContext.addCommitListener(false, () -> this.clusterHandler.runBackgroundTasks(list));
                return true;
            });
        }
    }

    private List<BackgroundTaskExecutionContext> nextBatch(Set<Long> set) {
        Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.MINUTES, (int)1);
        int n = this.clusterHandler.getRemainingBackgroundTaskCapacity();
        if (n == 0) {
            return Collections.emptyList();
        }
        List list = ((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{BackgroundTaskExecutionRecurringTask.$.submittedAt.isNull().or((Predicate)BackgroundTaskExecutionRecurringTask.$.submittedAt.before((Comparable)date)), BackgroundTaskExecutionRecurringTask.$.scheduledFor.isNull().or(BackgroundTaskExecutionRecurringTask.$.scheduledFor.past()), CollectionHelper.isEmpty(set) ? BackgroundTaskExecutionRecurringTask.$.id.isNotNull() : BackgroundTaskExecutionRecurringTask.$.id.notIn(set)})).limit((long)Math.min(n, 200))).orderBy(new OrderSpecifier[]{BackgroundTaskExecutionRecurringTask.$.priority.desc(), BackgroundTaskExecutionRecurringTask.$.id.asc()})).list((Expression)Projections.constructor(BackgroundTaskExecutionContext.class, (Expression[])new Expression[]{BackgroundTaskExecutionRecurringTask.$.className, BackgroundTaskExecutionRecurringTask.$.context, BackgroundTaskExecutionRecurringTask.$.display, BackgroundTaskExecutionRecurringTask.$.id}));
        HashMap hashMap = new HashMap();
        ArrayList<BackgroundTaskExecutionContext> arrayList = new ArrayList<BackgroundTaskExecutionContext>(list.size());
        list.forEach(backgroundTaskExecutionContext -> {
            List list2;
            boolean bl = false;
            if (IndexEntitiesBackgroundTask.class.getName().equals(backgroundTaskExecutionContext.getClassName()) && (list2 = StringHelper.splitTrimming((String)backgroundTaskExecutionContext.getContext(), (String)"|")).size() == 2) {
                String string2 = (String)list2.get(0);
                List<Long> list3 = StringHelper.splitTrimming((String)((String)list2.get(1)), (String)",").stream().map(Long::valueOf).collect(Collectors.toList());
                if (list3.size() < 50) {
                    hashMap.computeIfAbsent(string2, string -> new IndexingTaskContext((String)string)).add((Long)CollectionHelper.first((Iterable)backgroundTaskExecutionContext.getExecutionIds()), list3);
                    bl = true;
                }
            }
            if (!bl) {
                arrayList.add((BackgroundTaskExecutionContext)backgroundTaskExecutionContext);
            }
        });
        hashMap.values().stream().map(object -> ((IndexingTaskContext)object).toBackgroundTaskExecutionContexts()).forEach(arrayList::addAll);
        return arrayList;
    }

    private void updateSubmission(List<BackgroundTaskExecutionContext> list) {
        Set set = list.stream().flatMap(backgroundTaskExecutionContext -> backgroundTaskExecutionContext.getExecutionIds().stream()).collect(Collectors.toSet());
        this.rawEntityManagerHandler.update((EntityPath)$).set((Path)BackgroundTaskExecutionRecurringTask.$.submittedAt, (Expression)DateTimeExpression.currentTimestamp()).where(new Predicate[]{BackgroundTaskExecutionRecurringTask.$.id.in(set)}).execute();
    }

    private static class IndexingTaskContext {
        private String indexName;
        private Map<Long, List<Long>> executions = new HashMap<Long, List<Long>>();

        private IndexingTaskContext(String string) {
            this.indexName = string;
        }

        private void add(Long l, List<Long> list) {
            this.executions.put(l, list);
        }

        private List<BackgroundTaskExecutionContext> toBackgroundTaskExecutionContexts() {
            ArrayList<BackgroundTaskExecutionContext> arrayList = new ArrayList<BackgroundTaskExecutionContext>();
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Runnable runnable = () -> {
                if (!hashSet.isEmpty() && !hashSet2.isEmpty()) {
                    arrayList.add(new BackgroundTaskExecutionContext(IndexEntitiesBackgroundTask.class.getName(), this.indexName + "|" + StringHelper.join((Collection)hashSet2, (String)","), null, new HashSet(hashSet)));
                    hashSet.clear();
                    hashSet2.clear();
                }
            };
            this.executions.forEach((l, list) -> {
                hashSet.add(l);
                hashSet2.addAll(list);
                if (hashSet2.size() > 50) {
                    runnable.run();
                }
            });
            runnable.run();
            return arrayList;
        }
    }
}

