/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.AbstractGlobalServerComponent;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.logging.LoggingHandler;
import org.cyclos.impl.logging.TaskLogParams;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.system.BalanceInconsistencyParameters;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.DbSchemaInconsistencyParameters;
import org.cyclos.impl.system.LicenseHandler;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.license.api.model.IssueReportType;
import org.cyclos.model.messaging.ErrorLogType;
import org.cyclos.model.system.configurations.TaskLoggingMode;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTask
extends AbstractGlobalServerComponent
implements HasMessageKey {
    @Autowired
    protected LoggingHandler loggingHandler;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    protected ErrorLogServiceLocal errorLogService;
    @Autowired
    protected ClusterHandler clusterHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    private String name;
    @Autowired
    private LicenseHandler licenseHandler;

    public final String getName() {
        if (this.name == null) {
            this.name = this.resolveName();
        }
        return this.name;
    }

    protected String getErrorLogName() {
        return this.getClass().getName();
    }

    protected abstract ErrorLogType getErrorLogType();

    protected LogConfiguration getLogConfiguration() {
        return (LogConfiguration)this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system((Network)this.getNetwork()), TransactionLevel.READ_ONLY, transactionStatus -> {
            ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
            return configurationAccessor.getLogConfiguration();
        });
    }

    protected Network getNetwork() {
        return null;
    }

    protected abstract boolean isVerbose();

    protected abstract String logName(String var1);

    protected void logTaskError(String string, Throwable throwable) {
        if (this.clusterHandler.isCausedByShutdown(throwable)) {
            return;
        }
        LogConfiguration logConfiguration = this.getLogConfiguration();
        if (logConfiguration.getTasksLoggingMode() != TaskLoggingMode.OFF) {
            TaskLogParams taskLogParams = new TaskLogParams();
            taskLogParams.setName(this.logName(string));
            taskLogParams.setError(throwable);
            this.loggingHandler.logTask(logConfiguration, taskLogParams);
        }
        if (this.cyclosProperties.isDumpAllErrors()) {
            this.getLogger().error("Error on task " + this.logName(string), throwable);
        }
        if (this.shouldGenerateErrorLog()) {
            this.invokerHandler.runAsInTransaction(SessionDataFactory.system((Network)this.getNetwork()), TransactionLevel.READ_WRITE, transactionStatus -> {
                String string = ExceptionUtils.getStackTrace((Throwable)throwable);
                this.errorLogService.create(this.getErrorLogType(), this.getErrorLogName(), string);
                return null;
            });
        }
    }

    protected void logTaskSuccess(String string, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        LogConfiguration logConfiguration = this.getLogConfiguration();
        if (this.shouldLogTaskSuccess(logConfiguration)) {
            TaskLogParams taskLogParams = new TaskLogParams();
            taskLogParams.setName(this.logName(string));
            taskLogParams.setTimeTaken(Long.valueOf(l));
            taskLogParams.setAffectedRecords(Long.valueOf(l2));
            this.loggingHandler.logTask(logConfiguration, taskLogParams);
        }
    }

    protected void notifyIssueToLicense(BalanceInconsistencyParameters balanceInconsistencyParameters) {
        this.notifyIssueToLicense(IssueReportType.INCONSISTENT_BALANCE, () -> balanceInconsistencyParameters);
    }

    protected void notifyIssueToLicense(Supplier<DbSchemaInconsistencyParameters> supplier) {
        this.notifyIssueToLicense(IssueReportType.INCONSISTENT_DB_SCHEMA, supplier);
    }

    protected String resolveName() {
        return (String)this.invokerHandler.runAs(SessionDataFactory.system((Network)this.getNetwork()), () -> this.translationHandler.getOriginalEnglishResourceBundle().get(this.getMessageKey()));
    }

    protected boolean shouldGenerateErrorLog() {
        return true;
    }

    private void doNotify(IssueReportType issueReportType, Object object) {
        try {
            switch (issueReportType) {
                case INCONSISTENT_BALANCE: {
                    this.licenseHandler.reportInconsistentBalance((BalanceInconsistencyParameters)object);
                    break;
                }
                case INCONSISTENT_DB_SCHEMA: {
                    this.licenseHandler.reportInconsistentDbSchema((DbSchemaInconsistencyParameters)object);
                }
            }
        }
        catch (Exception exception) {
            this.getLogger().warn("Error notifying the license server about an issue of type {}: {}", (Object)issueReportType, (Object)exception);
        }
    }

    private void notifyIssueToLicense(IssueReportType issueReportType, Supplier<?> supplier) {
        if (this.cyclosProperties.isLicenseIgnoreIssueReports()) {
            return;
        }
        this.invokerHandler.submitAsInParallelTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> this.doNotify(issueReportType, supplier.get()));
    }

    private boolean shouldLogTaskSuccess(LogConfiguration logConfiguration) {
        TaskLoggingMode taskLoggingMode = (TaskLoggingMode)ObjectHelper.defaultValue((Object)logConfiguration.getTasksLoggingMode(), (Object)TaskLoggingMode.REGULAR);
        switch (taskLoggingMode) {
            case OFF: {
                return false;
            }
            case VERBOSE: {
                return true;
            }
            case REGULAR: {
                return !this.isVerbose();
            }
        }
        return false;
    }
}

