/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.utils.QRecurringTaskExecution;
import org.cyclos.entities.utils.RecurringTaskExecution;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.utils.TabularPrinter;
import org.cyclos.impl.utils.tasks.RecurringTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandlerImplementor;
import org.cyclos.impl.utils.tasks.RunningTaskDescriptor;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractRecurringTaskHandlerImpl
extends BaseGlobalHandlerImpl
implements RecurringTaskHandlerImplementor {
    protected static final QRecurringTaskExecution $ = QRecurringTaskExecution.recurringTaskExecution;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    protected CyclosProperties cyclosProperties;
    protected Map<RecurringTaskRecurrence, List<RecurringTask>> tasksByRecurrenceMap;
    private Map<String, RunningTaskDescriptor> runningTasks = Collections.synchronizedMap(new HashMap());

    public <R> Map<RecurringTask, R> forEachTask(Function<RecurringTask, R> function) {
        this.ensureTasksByRecurrenceMap();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.tasksByRecurrenceMap.entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(recurringTask -> linkedHashMap.put(recurringTask, function.apply((RecurringTask)recurringTask))));
        return linkedHashMap;
    }

    public Date getFirstExecution(RecurringTask recurringTask) {
        switch (recurringTask.getFirstExecution()) {
            case NEXT: {
                return this.getNextExecution(recurringTask);
            }
            case NOW: {
                return this.dateFromDelay((long)(Math.random() * 10000.0));
            }
            case RANDOM: {
                long l = this.getNextExecution(recurringTask).getTime() - System.currentTimeMillis();
                return this.dateFromDelay((long)(Math.random() * (double)l));
            }
        }
        throw new IllegalArgumentException("Unknown task first execution: " + String.valueOf(recurringTask.getFirstExecution()));
    }

    public Date getNextExecution(RecurringTask recurringTask) {
        switch (recurringTask.getRecurrence()) {
            case EVERY_DAY: {
                return this.dateFromDelay(86400000L);
            }
            case EVERY_HALF_HOUR: {
                return this.dateFromDelay(1800000L);
            }
            case EVERY_HOUR: {
                return this.dateFromDelay(3600000L);
            }
            case EVERY_MINUTE: {
                return this.dateFromDelay(60000L);
            }
            case NEXT_DAY: {
                return Date.from(ZonedDateTime.now(this.referenceClock()).plus(1L, ChronoUnit.DAYS).truncatedTo(ChronoUnit.DAYS).plus(1L, ChronoUnit.HOURS).toInstant());
            }
            case NEXT_HOUR: {
                return Date.from(ZonedDateTime.now(Clock.systemDefaultZone()).plus(1L, ChronoUnit.HOURS).truncatedTo(ChronoUnit.HOURS).toInstant());
            }
        }
        throw new IllegalArgumentException("Unknown task recurrence: " + String.valueOf(recurringTask.getRecurrence()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RunningTaskDescriptor> getRunningTasks() {
        Map<String, RunningTaskDescriptor> map = this.runningTasks;
        synchronized (map) {
            return this.runningTasks.values().stream().collect(Collectors.toUnmodifiableSet());
        }
    }

    public <T extends RecurringTask> T getTask(Class<T> clazz) {
        return (T)((RecurringTask)this.getApplicationContext().getBean(clazz));
    }

    public void logFirstExecution(Map<RecurringTask, Long> map) {
        ZoneId zoneId = (ZoneId)this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> ZoneId.of(this.getSessionData().getConfiguration().getTimeZoneId()));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Map<RecurringTask, String[]> map2 = this.forEachTask(recurringTask -> new String[]{recurringTask.getName(), dateTimeFormatter.format(LocalDateTime.now(zoneId).plus((Long)map.get(recurringTask), ChronoUnit.MILLIS)) + (String)(!this.cyclosProperties.isDevelopment() ? "" : " (using " + this.getFirstExecutionName(recurringTask.getFirstExecution()) + ")"), this.getRecurrenceName(recurringTask.getRecurrence()), recurringTask.getNotesForLogging()});
        String[] stringArray = new String[]{String.format("Recurring task (using %d workers)", this.cyclosProperties.getMaxRecurringTasks()), "First execution (" + String.valueOf(zoneId) + ")", "Recurrence", "Notes"};
        String[][] stringArray2 = (String[][])map2.values().stream().collect(Collectors.toList()).toArray((T[])new String[map2.size()][]);
        this.getLogger().info("Table with the scheduled recurring tasks:");
        this.getLogger().info("\n" + TabularPrinter.formatAsTable(stringArray, stringArray2, true));
    }

    public void onApplicationInitialization() {
        List list = this.getApplicationContext().getBeansOfType(RecurringTask.class).values().stream().map(recurringTask -> recurringTask.getClass().getName()).collect(Collectors.toList());
        this.delete((EntityPath<?>)$).where(new Predicate[]{AbstractRecurringTaskHandlerImpl.$.className.notIn(list)}).execute();
        List list2 = this.from(new EntityPath[]{$}).list((Expression)AbstractRecurringTaskHandlerImpl.$.className);
        ArrayList arrayList = new ArrayList(list);
        arrayList.removeAll(list2);
        arrayList.forEach(string -> {
            RecurringTaskExecution recurringTaskExecution = new RecurringTaskExecution();
            recurringTaskExecution.setClassName(string);
            this.rawEntityManagerHandler.getEntityManager().persist((Object)recurringTaskExecution);
        });
        this.update((EntityPath<?>)$).setNull((Path)AbstractRecurringTaskHandlerImpl.$.startDate).execute();
    }

    public void onTaskFinished(RecurringTask recurringTask) {
        String string = recurringTask.getClass().getName();
        this.runningTasks.remove(string);
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.update((EntityPath<?>)$).set((Path)AbstractRecurringTaskHandlerImpl.$.lastStartDate, (Expression)AbstractRecurringTaskHandlerImpl.$.startDate).set((Path)AbstractRecurringTaskHandlerImpl.$.lastEndDate, (Expression)DateTimeExpression.currentTimestamp()).setNull((Path)AbstractRecurringTaskHandlerImpl.$.startDate).where(new Predicate[]{AbstractRecurringTaskHandlerImpl.$.className.eq((Object)string)}).execute());
    }

    public void onTaskStarted(RecurringTask recurringTask) {
        String string = recurringTask.getClass().getName();
        this.runningTasks.put(string, new RunningTaskDescriptor(new Date(), string));
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.update((EntityPath<?>)$).set((Path)AbstractRecurringTaskHandlerImpl.$.startDate, (Expression)DateTimeExpression.currentTimestamp()).where(new Predicate[]{AbstractRecurringTaskHandlerImpl.$.className.eq((Object)string)}).execute());
    }

    public void scheduleAwake(Class<? extends RecurringTask> clazz) {
        RecurringTask recurringTask = this.getTask(clazz);
        if (recurringTask == null) {
            throw new IllegalArgumentException("No RecurringTask for the given type " + String.valueOf(clazz));
        }
        this.getLogger().debug("Scheduling recurring task '{}' for awakening", (Object)recurringTask);
        InvocationContext.ensure().awakeRecurringTask(recurringTask);
    }

    protected Date dateFromDelay(long l) {
        return new Date(System.currentTimeMillis() + l);
    }

    protected void logTaskWorkersInfo() {
        if (this.cyclosProperties.getMaxRecurringTasks() <= 0) {
            this.getLogger().info("Recurring & background tasks disabled for this node.");
        } else {
            this.getLogger().info("Tasks enabled using {} workers for recurring and {} workers for background.", (Object)this.cyclosProperties.getMaxRecurringTasks(), (Object)this.cyclosProperties.getMaxBackgroundTasks());
        }
    }

    private void ensureTasksByRecurrenceMap() {
        if (this.tasksByRecurrenceMap != null) {
            return;
        }
        Comparator<RecurringTask> comparator = Comparator.comparing(RecurringTask::getRecurrence).thenComparing(RecurringTask::getName);
        this.tasksByRecurrenceMap = this.getApplicationContext().getBeansOfType(RecurringTask.class).values().stream().sorted(comparator).collect(Collectors.toMap(RecurringTask::getRecurrence, recurringTask -> {
            ArrayList<RecurringTask> arrayList = new ArrayList<RecurringTask>();
            arrayList.add((RecurringTask)recurringTask);
            return arrayList;
        }, (list, list2) -> {
            list.addAll(list2);
            return list;
        }, LinkedHashMap::new));
    }

    private String getFirstExecutionName(RecurringTaskFirstExecution recurringTaskFirstExecution) {
        if (recurringTaskFirstExecution == null) {
            return "";
        }
        switch (recurringTaskFirstExecution) {
            case NEXT: {
                return "Next";
            }
            case NOW: {
                return "Now";
            }
            case RANDOM: {
                return "Random";
            }
        }
        return recurringTaskFirstExecution.name();
    }

    private String getRecurrenceName(RecurringTaskRecurrence recurringTaskRecurrence) {
        if (recurringTaskRecurrence == null) {
            return "";
        }
        switch (recurringTaskRecurrence) {
            case EVERY_DAY: {
                return "Every day";
            }
            case EVERY_HALF_HOUR: {
                return "Every half hour";
            }
            case EVERY_HOUR: {
                return "Every hour";
            }
            case EVERY_MINUTE: {
                return "Every minute";
            }
            case NEXT_DAY: {
                return "Next day";
            }
            case NEXT_HOUR: {
                return "Next hour";
            }
        }
        return recurringTaskRecurrence.name();
    }

    private Clock referenceClock() {
        return (Clock)this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            Configuration configuration = this.configurationHandler.getGlobalDefault();
            return Clock.system(ZoneId.of(configuration == null ? "GMT" : configuration.getTimeZoneId()));
        });
    }
}

