/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.system.PaymentSmsOperationConfiguration;
import org.cyclos.entities.system.SendPaymentRequestSmsOperationConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.SchedulingType;
import org.cyclos.model.banking.transactions.SendPaymentRequestDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.security.Security;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.services.banking.PaymentRequestService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.springframework.beans.factory.annotation.Autowired;

public class SendPaymentRequestSmsOperation
extends BaseSmsOperation {
    private static final Logger LOG = LogManager.getLogger(SendPaymentRequestSmsOperation.class);
    @Autowired
    @Security
    private PaymentRequestService paymentRequestService;

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        int n;
        PaymentSmsOperationConfiguration paymentSmsOperationConfiguration = (PaymentSmsOperationConfiguration)smsOperationConfiguration;
        boolean bl = paymentSmsOperationConfiguration.isUsePassword();
        int n2 = n = bl ? 3 : 2;
        if (paymentSmsOperationConfiguration.getPaymentType().isUseFixedAmount()) {
            --n;
        }
        if (CollectionHelper.size(list) != n) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[]{n, n});
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        LOG.debug(String.format("Executing SMS Send payment request operation (user: %1$s, sms: %2$s)", mobilePhone.getUser().getUsername(), inboundSmsData));
        User user = smsParameterProcessor.nextUserForPayment((Object)MessagingKeys.Notifications.SMS_SEND_PAYMENT_REQUEST_PARAMETER_PAYER);
        SendPaymentRequestSmsOperationConfiguration sendPaymentRequestSmsOperationConfiguration = (SendPaymentRequestSmsOperationConfiguration)smsOperationConfiguration;
        PaymentTransferType paymentTransferType = sendPaymentRequestSmsOperationConfiguration.getPaymentType();
        BigDecimal bigDecimal = paymentTransferType.isUseFixedAmount() ? paymentTransferType.getFixedAmount() : smsParameterProcessor.nextAmount((Object)MessagingKeys.Notifications.SMS_SEND_PAYMENT_REQUEST_PARAMETER_AMOUNT, paymentTransferType.getFrom().getCurrency().getPrecision());
        SendPaymentRequestDTO sendPaymentRequestDTO = new SendPaymentRequestDTO();
        sendPaymentRequestDTO.setAmount(bigDecimal);
        sendPaymentRequestDTO.setOwner((InternalAccountOwner)mobilePhone.getUser());
        sendPaymentRequestDTO.setSubject((InternalAccountOwner)user);
        sendPaymentRequestDTO.setExpirationDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)DateHelper.add((Date)DateHelper.now(), (ITimeInterval)sendPaymentRequestSmsOperationConfiguration.getExpirationInterval())));
        sendPaymentRequestDTO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)paymentTransferType));
        sendPaymentRequestDTO.setScheduling(SchedulingType.NOT_SCHEDULED);
        PaymentRequestVO paymentRequestVO = this.paymentRequestService.send(sendPaymentRequestDTO);
        boolean bl = paymentTransferType.getCurrency().isTransactionNumberEnabled();
        Object[] objectArray = new Object[]{this.getFormatter().format((IDate)paymentRequestVO.getExpirationDate()), bl ? this.message(MessagingKeys.Notifications.TRANSACTION_NUMBER, paymentRequestVO.getTransactionNumber()) : ""};
        this.sendResponse(mobilePhone, this.message(MessagingKeys.Notifications.SMS_SEND_PAYMENT_REQUEST_RESPONSE_SUCCESSFULLY, objectArray));
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        SendPaymentRequestSmsOperationConfiguration sendPaymentRequestSmsOperationConfiguration = (SendPaymentRequestSmsOperationConfiguration)smsOperationConfiguration;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (sendPaymentRequestSmsOperationConfiguration.isUsePassword()) {
            PasswordType passwordType = smsOperationConfiguration.getChannelConfiguration().getAccessPassword();
            arrayList.add(this.dataTranslationHandler.getName((NamedEntity)passwordType));
        }
        arrayList.add(this.message(MessagingKeys.Notifications.SMS_SEND_PAYMENT_REQUEST_PARAMETER_PAYER, new Object[0]));
        if (!sendPaymentRequestSmsOperationConfiguration.getPaymentType().isUseFixedAmount()) {
            arrayList.add(this.message(MessagingKeys.Notifications.SMS_SEND_PAYMENT_REQUEST_PARAMETER_AMOUNT, new Object[0]));
        }
        return arrayList;
    }
}

