/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.system.PaymentSmsOperationConfiguration;
import org.cyclos.entities.system.PerformExternalPaymentSmsOperationConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.security.Security;
import org.cyclos.services.banking.ExternalPaymentService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class PerformExternalPaymentSmsOperation
extends BaseSmsOperation {
    private static final Logger LOG = LogManager.getLogger(PerformExternalPaymentSmsOperation.class);
    @Autowired
    @Security
    private ExternalPaymentService externalPaymentService;
    @Autowired
    private AccountServiceLocal accountService;

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        int n;
        PerformExternalPaymentSmsOperationConfiguration performExternalPaymentSmsOperationConfiguration = (PerformExternalPaymentSmsOperationConfiguration)smsOperationConfiguration;
        boolean bl = performExternalPaymentSmsOperationConfiguration.isUsePassword();
        int n2 = n = bl ? 3 : 2;
        if (performExternalPaymentSmsOperationConfiguration.getPaymentType().isUseFixedAmount()) {
            --n;
        }
        if (CollectionHelper.size(list) != n) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[]{n, n});
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        LOG.debug(String.format("Executing SMS Perform external payment operation (user: %1$s, sms: %2$s)", mobilePhone.getUser().getUsername(), inboundSmsData));
        PaymentSmsOperationConfiguration paymentSmsOperationConfiguration = (PaymentSmsOperationConfiguration)smsOperationConfiguration;
        PerformExternalPaymentDTO performExternalPaymentDTO = new PerformExternalPaymentDTO();
        String string = smsParameterProcessor.nextString((Object)MessagingKeys.Notifications.SMS_PERFORM_EXTERNAL_PAYMENT_PARAMETER_PRINCIPAL_VALUE);
        PrincipalTypeVO principalTypeVO = this.isEmail(string) ? new PrincipalTypeVO(PrincipalTypeVO.INTERNAL_NAME, (Object)ExistingBuiltInPrincipalType.EMAIL.getInternalName()) : new PrincipalTypeVO(PrincipalTypeVO.INTERNAL_NAME, (Object)ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName());
        performExternalPaymentDTO.setToPrincipalType(principalTypeVO);
        performExternalPaymentDTO.setToPrincipalValue(string);
        performExternalPaymentDTO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)paymentSmsOperationConfiguration.getPaymentType()));
        BigDecimal bigDecimal = paymentSmsOperationConfiguration.getPaymentType().isUseFixedAmount() ? paymentSmsOperationConfiguration.getPaymentType().getFixedAmount() : smsParameterProcessor.nextAmount((Object)MessagingKeys.Notifications.SMS_PERFORM_EXTERNAL_PAYMENT_PARAMETER_AMOUNT, paymentSmsOperationConfiguration.getPaymentType().getFrom().getCurrency().getPrecision());
        performExternalPaymentDTO.setAmount(bigDecimal);
        ExternalPaymentVO externalPaymentVO = null;
        try {
            externalPaymentVO = this.externalPaymentService.perform(performExternalPaymentDTO);
        }
        catch (InsufficientBalanceException insufficientBalanceException) {
            throw new SmsOperationException((Throwable)insufficientBalanceException, (Object)MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_INSUFICIENT_BALANCE, new Object[]{new CurrencyAmount(paymentSmsOperationConfiguration.getPaymentType().getCurrency(), bigDecimal), string});
        }
        AccountType accountType = paymentSmsOperationConfiguration.getPaymentType().getFrom();
        Account account = this.accountService.load((InternalAccountOwner)mobilePhone.getUser(), accountType);
        BigDecimal bigDecimal2 = this.accountService.getAvailableBalance(account, null);
        boolean bl = paymentSmsOperationConfiguration.getPaymentType().getCurrency().isTransactionNumberEnabled();
        CurrencyAmount currencyAmount = new CurrencyAmount(paymentSmsOperationConfiguration.getPaymentType().getCurrency(), bigDecimal2);
        Object[] objectArray = new Object[]{paymentSmsOperationConfiguration.getPaymentType(), string, externalPaymentVO.getCurrencyAmount(), currencyAmount, bl ? this.message(MessagingKeys.Notifications.TRANSACTION_NUMBER, externalPaymentVO.getTransactionNumber()) : ""};
        this.sendResponse(mobilePhone, this.message(MessagingKeys.Notifications.SMS_PERFORM_EXTERNAL_PAYMENT_RESPONSE_SUCCESSFULLY, objectArray));
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        PerformExternalPaymentSmsOperationConfiguration performExternalPaymentSmsOperationConfiguration = (PerformExternalPaymentSmsOperationConfiguration)smsOperationConfiguration;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (performExternalPaymentSmsOperationConfiguration.isUsePassword()) {
            PasswordType passwordType = smsOperationConfiguration.getChannelConfiguration().getAccessPassword();
            arrayList.add(this.dataTranslationHandler.getName((NamedEntity)passwordType));
        }
        arrayList.add(this.message(MessagingKeys.Notifications.SMS_PERFORM_EXTERNAL_PAYMENT_PARAMETER_PRINCIPAL_VALUE, new Object[0]));
        if (!performExternalPaymentSmsOperationConfiguration.getPaymentType().isUseFixedAmount()) {
            arrayList.add(this.message(MessagingKeys.Notifications.SMS_PERFORM_EXTERNAL_PAYMENT_PARAMETER_AMOUNT, new Object[0]));
        }
        return arrayList;
    }

    protected boolean isEmail(String string) {
        return string.contains("@");
    }
}

