/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cyclos.entities.messaging.OutboundSms;
import org.cyclos.entities.messaging.QOutboundSms;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.sms.GatewaySmsSender;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.sms.ScriptSmsSender;
import org.cyclos.impl.utils.sms.SmsSender;
import org.cyclos.model.IEntity;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.sms.OutboundSmsStatus;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutboundSmsHandlerImpl
extends BaseNetworkedHandlerImpl
implements OutboundSmsHandler {
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private AlertServiceLocal alertService;

    public int getCurrentSmsCountForUser(User user) {
        DatePeriod datePeriod = DatePeriod.periodIncluding((ITimeInterval)TimeInterval.ONE_MONTH, (TimeZone)this.configurationHandler.getAccessAccessor((BasicUser)user).getTimeZone(), (Date)new Date());
        return this.getCurrentSmsCountForUser(user, datePeriod);
    }

    public List<OutboundSms> send(BasicUser basicUser, String string, OutboundSmsType outboundSmsType) {
        List list = this.phoneService.listEnabledPhonesForSmsNotification(basicUser, outboundSmsType.isIncludeOperators());
        return this.doSend(null, basicUser, list, string, true, true, 0, outboundSmsType);
    }

    public List<OutboundSms> send(List<MobilePhone> list, String string, OutboundSmsType outboundSmsType) {
        return list.stream().map(mobilePhone -> (OutboundSms)CollectionHelper.first(this.doSend(null, mobilePhone.getUser(), Collections.singletonList(mobilePhone), string, true, true, 0, outboundSmsType))).collect(Collectors.toList());
    }

    public OutboundSms send(MobilePhone mobilePhone, String string, OutboundSmsType outboundSmsType) {
        List<OutboundSms> list = this.doSend(null, mobilePhone.getUser(), Collections.singletonList(mobilePhone), string, true, true, 0, outboundSmsType);
        return (OutboundSms)CollectionHelper.first(list);
    }

    public OutboundSms sendEvenIfDisabled(MobilePhone mobilePhone, String string, OutboundSmsType outboundSmsType) {
        List<OutboundSms> list = this.doSend(null, (BasicUser)mobilePhone.getUser().getUser(), Collections.singletonList(mobilePhone), string, false, true, 0, outboundSmsType);
        return (OutboundSms)CollectionHelper.first(list);
    }

    public OutboundSms sendToUnregistered(ConfigurationAccessor configurationAccessor, String string, String string2, OutboundSmsType outboundSmsType) {
        return this.sendToUnregistered(configurationAccessor, string, string2, outboundSmsType, configurationAccessor.getOutboundSmsConfiguration().getMaxMessagesToUnregistered());
    }

    public OutboundSms sendToUnregistered(ConfigurationAccessor configurationAccessor, String string, String string2, OutboundSmsType outboundSmsType, Integer n) {
        List<OutboundSms> list = this.doSend(configurationAccessor, null, Collections.singletonList(string), string2, false, true, n, outboundSmsType);
        return (OutboundSms)CollectionHelper.first(list);
    }

    public List<OutboundSms> sendUnrestricted(BasicUser basicUser, String string, OutboundSmsType outboundSmsType) {
        List list = this.phoneService.listEnabledPhonesForSmsNotification(basicUser, outboundSmsType.isIncludeOperators());
        return this.doSend(null, basicUser, list, string, true, false, 0, outboundSmsType);
    }

    private List<OutboundSms> doSend(ConfigurationAccessor configurationAccessor, @Nullable BasicUser basicUser, List<?> list, String string, boolean bl, boolean bl2, Integer n, OutboundSmsType outboundSmsType) {
        Object object;
        OutboundSmsConfiguration outboundSmsConfiguration;
        User user;
        if (CollectionHelper.isEmpty(list) || StringHelper.isBlank((Object)string)) {
            return Collections.emptyList();
        }
        if (basicUser == null && CollectionHelper.size(list) > 1) {
            throw new IllegalStateException("When not sending to a user, this method can only be used to send to a single phone");
        }
        User user2 = user = basicUser == null ? null : basicUser.getUser();
        if (configurationAccessor == null && basicUser != null) {
            configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        }
        OutboundSmsConfiguration outboundSmsConfiguration2 = outboundSmsConfiguration = configurationAccessor == null ? null : configurationAccessor.getOutboundSmsConfiguration();
        if (outboundSmsConfiguration == null || !outboundSmsConfiguration.isEnabled()) {
            return Collections.emptyList();
        }
        DatePeriod datePeriod = DatePeriod.periodIncluding((ITimeInterval)TimeInterval.ONE_MONTH, (TimeZone)configurationAccessor.getTimeZone(), (Date)new Date());
        int n2 = (Integer)ObjectHelper.defaultValue((Object)outboundSmsConfiguration.getMaxMessagesPerMonth(), (Object)0);
        Configuration configuration = configurationAccessor.getConfigurationFor(ConfigurationDTO.OUTBOUND_SMS_CONFIGURATION.getName());
        int n3 = 0;
        if (n2 > 0) {
            n3 = this.getCurrentSmsCountForConfiguration(configuration.getId(), datePeriod);
        }
        int n4 = 0;
        Integer n5 = null;
        if (user != null) {
            object = this.productsHandler.getAccessor((BasicUser)user);
            n5 = object.product().getMaxSmsPerMonth();
            if (n5 == 0) {
                n5 = null;
            }
            this.lockHandler.lock(LockType.OUTBOUND_SMS.key(user.getId()));
            n4 = this.getCurrentSmsCountForUser(user, datePeriod);
            String string2 = string;
            string = (String)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)user), () -> {
                Function function = this.profileFieldHandler.getUserVariablesFunction((BasicUser)user);
                return StringHelper.replaceVariables((String)string2, (Function)function);
            });
        } else {
            n5 = n;
            object = (String)CollectionHelper.first(list);
            n4 = this.getCurrentSmsCountForUnregistered((String)object, datePeriod);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        ArrayList<OutboundSms> arrayList = new ArrayList<OutboundSms>();
        for (Object obj : list) {
            SmsSender smsSender;
            OutboundSmsStatus outboundSmsStatus;
            String string3;
            MobilePhone mobilePhone;
            if (obj instanceof MobilePhone) {
                mobilePhone = (MobilePhone)obj;
                string3 = mobilePhone.getNormalizedNumber();
                if (StringHelper.isBlank((Object)string3) || bl && !mobilePhone.isEnabledForSms()) {
                    continue;
                }
            } else {
                mobilePhone = null;
                string3 = obj.toString();
            }
            if (n2 > 0 && n3 >= n2) {
                outboundSmsStatus = OutboundSmsStatus.MAX_GLOBAL_MESSAGES_REACHED;
            } else if (bl2 && n5 != null && n4 >= n5) {
                outboundSmsStatus = user == null ? OutboundSmsStatus.MAX_UNREGISTERED_MESSAGES_REACHED : OutboundSmsStatus.MAX_USER_MESSAGES_REACHED;
            } else {
                smsSender = this.getSmsSender(outboundSmsConfiguration);
                try {
                    outboundSmsStatus = smsSender.send(configurationAccessor, mobilePhone, string3, string);
                    if (n2 > 0 && n3 + 1 == n2) {
                        bl4 = true;
                    }
                    if (n5 != null && n4 + 1 == n5) {
                        bl3 = true;
                    }
                }
                catch (Exception exception) {
                    this.getLogger().error("Error sending SMS message", (Throwable)exception);
                    outboundSmsStatus = OutboundSmsStatus.UNKNOWN_ERROR;
                }
            }
            smsSender = new OutboundSms();
            smsSender.setConfigurationId(configuration.getId());
            smsSender.setDate(new Date());
            smsSender.setUser(basicUser);
            smsSender.setNetwork(this.getSessionData().getNetwork());
            smsSender.setPhoneNumber(string3);
            smsSender.setStatus(outboundSmsStatus);
            smsSender.setMessage(string);
            smsSender.setType(outboundSmsType);
            this.persist((IEntity)smsSender);
            arrayList.add((OutboundSms)smsSender);
            if (outboundSmsStatus == OutboundSmsStatus.SUCCESS) {
                ++n4;
                ++n3;
                continue;
            }
            this.alertService.create(SystemAlertType.SMS_SENDING_FAILED, new Object[]{string3, outboundSmsStatus});
        }
        if (bl4) {
            this.alertService.create(SystemAlertType.MAX_GLOBAL_SMS_REACHED, new Object[]{n2, configurationAccessor.getConfiguration().getName()});
        }
        if (bl3 && user != null) {
            this.notificationHandler.user((BasicUser)user).personal().maxSmsPerMonthReached(user, n5);
        }
        return arrayList;
    }

    private int getCurrentSmsCountForConfiguration(Long l, DatePeriod datePeriod) {
        QOutboundSms qOutboundSms = QOutboundSms.outboundSms;
        return ((DBQuery)this.from(new EntityPath[]{qOutboundSms}).where(new Predicate[]{qOutboundSms.configurationId.eq((Object)l), qOutboundSms.status.eq((Object)OutboundSmsStatus.SUCCESS), qOutboundSms.date.period(datePeriod)})).count(qOutboundSms.id);
    }

    private int getCurrentSmsCountForUnregistered(String string, DatePeriod datePeriod) {
        QOutboundSms qOutboundSms = QOutboundSms.outboundSms;
        return ((DBQuery)this.from(new EntityPath[]{qOutboundSms}).where(new Predicate[]{qOutboundSms.user().isNull(), qOutboundSms.phoneNumber.eq((Object)string), qOutboundSms.status.eq((Object)OutboundSmsStatus.SUCCESS), qOutboundSms.date.period(datePeriod)})).count(qOutboundSms.id);
    }

    private int getCurrentSmsCountForUser(User user, DatePeriod datePeriod) {
        QOutboundSms qOutboundSms = QOutboundSms.outboundSms;
        return ((DBQuery)this.from(new EntityPath[]{qOutboundSms}).where(new Predicate[]{qOutboundSms.user().eq((Object)user), qOutboundSms.status.eq((Object)OutboundSmsStatus.SUCCESS), qOutboundSms.date.period(datePeriod), qOutboundSms.type.ne((Object)OutboundSmsType.MAX_USER_MESSAGES_REACHED)})).count(qOutboundSms.id);
    }

    private SmsSender getSmsSender(OutboundSmsConfiguration outboundSmsConfiguration) {
        if (outboundSmsConfiguration.getScript() != null) {
            return (SmsSender)this.beanHandler.getBean(ScriptSmsSender.class);
        }
        return (SmsSender)this.beanHandler.getBean(GatewaySmsSender.class);
    }
}

