/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.messaging.InboundSms;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.CustomSmsOperationConfiguration;
import org.cyclos.entities.system.QSmsOperationConfiguration;
import org.cyclos.entities.system.RegisterSmsOperationConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.system.WithPasswordSmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.QMobilePhone;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.UrgentSituation;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.sms.AcceptPaymentRequestSmsOperation;
import org.cyclos.impl.utils.sms.AccountInformationSmsOperation;
import org.cyclos.impl.utils.sms.CustomSmsOperation;
import org.cyclos.impl.utils.sms.DenyPaymentRequestSmsOperation;
import org.cyclos.impl.utils.sms.HelpSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsBasicData;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.InboundSmsHandler;
import org.cyclos.impl.utils.sms.InboundSmsRequestHandler;
import org.cyclos.impl.utils.sms.InboundSmsRequestHandlerImpl;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.sms.PaymentSmsOperation;
import org.cyclos.impl.utils.sms.PerformExternalPaymentSmsOperation;
import org.cyclos.impl.utils.sms.RedeemVoucherSmsOperation;
import org.cyclos.impl.utils.sms.RegisterSmsOperation;
import org.cyclos.impl.utils.sms.ScriptInboundSmsRequestHandlerImpl;
import org.cyclos.impl.utils.sms.SendPaymentRequestSmsOperation;
import org.cyclos.impl.utils.sms.SmsOperation;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.TextSmsOperation;
import org.cyclos.model.IEntity;
import org.cyclos.model.RetryException;
import org.cyclos.model.access.InaccessibleChannelException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.sms.InboundSmsStatus;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationExecution;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CallableRunnable;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class InboundSmsHandlerImpl
extends BaseGlobalHandlerImpl
implements InboundSmsHandler {
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private EntityManagerHandler entityManagerHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private InternetAddressListHandler internetAddressListHandler;
    @Autowired
    protected ConfigurationHandler configurationHandler;

    public SmsOperation getSmsOperation(SmsOperationConfiguration smsOperationConfiguration) {
        if (smsOperationConfiguration == null) {
            throw new IllegalArgumentException("Null sms operation configuration");
        }
        Class clazz = null;
        switch (smsOperationConfiguration.getNature()) {
            case ACCOUNT_INFORMATION: {
                clazz = AccountInformationSmsOperation.class;
                break;
            }
            case CUSTOM: {
                clazz = CustomSmsOperation.class;
                break;
            }
            case HELP: {
                clazz = HelpSmsOperation.class;
                break;
            }
            case PAYMENT: {
                clazz = PaymentSmsOperation.class;
                break;
            }
            case REGISTER: {
                clazz = RegisterSmsOperation.class;
                break;
            }
            case TEXT: {
                clazz = TextSmsOperation.class;
                break;
            }
            case ACCEPT_PAYMENT_REQUEST: {
                clazz = AcceptPaymentRequestSmsOperation.class;
                break;
            }
            case SEND_PAYMENT_REQUEST: {
                clazz = SendPaymentRequestSmsOperation.class;
                break;
            }
            case DENY_PAYMENT_REQUEST: {
                clazz = DenyPaymentRequestSmsOperation.class;
                break;
            }
            case PERFORM_EXTERNAL_PAYMENT: {
                clazz = PerformExternalPaymentSmsOperation.class;
                break;
            }
            case REDEEM_VOUCHER: {
                clazz = RedeemVoucherSmsOperation.class;
            }
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown sms operation configuration nature:" + String.valueOf(smsOperationConfiguration.getNature()));
        }
        return (SmsOperation)this.beanHandler.getBean(clazz);
    }

    public ResponseInfo handleInboundSms(RequestData requestData) {
        ExecuteSmsResult executeSmsResult;
        InboundSmsBasicData inboundSmsBasicData;
        Pair<SmsChannelConfiguration, InboundSmsRequestHandler> pair;
        try {
            pair = this.resolveSmsConfigurationAndHandler(requestData);
        }
        catch (Exception exception) {
            this.getLogger().error("Error while getting the channel configuration for inbound SMS on {}", (Object)new Object[]{requestData.getBaseUrl()}, (Object)exception);
            ResponseInfo responseInfo = new ResponseInfo();
            responseInfo.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return responseInfo;
        }
        if (pair == null) {
            this.getLogger().warn("Received an Inbound SMS request, but the SMS channel is disabled on {}", (Object)requestData.getBaseUrl());
            ResponseInfo responseInfo = new ResponseInfo();
            responseInfo.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
            return responseInfo;
        }
        SmsChannelConfiguration smsChannelConfiguration = (SmsChannelConfiguration)pair.getFirst();
        InboundSmsRequestHandler inboundSmsRequestHandler = (InboundSmsRequestHandler)pair.getSecond();
        String string = requestData.getRemoteAddress();
        Boolean bl = (Boolean)this.invokerHandler.runAsInTransaction(this.sessionData(requestData), TransactionLevel.READ_ONLY, transactionStatus -> this.internetAddressListHandler.isWhitelisted(smsChannelConfiguration.getWhitelist(), string));
        if (!bl.booleanValue()) {
            this.getLogger().warn("Received an Inbound SMS request from {}, a host which is not in the white list on {}", new Object[]{string, requestData.getBaseUrl()});
            ResponseInfo responseInfo = new ResponseInfo();
            responseInfo.setStatus(HttpStatus.UNAUTHORIZED.value());
            return responseInfo;
        }
        boolean bl2 = false;
        try {
            inboundSmsBasicData = this.resolveSmsData(requestData, smsChannelConfiguration, inboundSmsRequestHandler);
        }
        catch (Exception exception) {
            this.getLogger().error("Error while resolving data for an inbound SMS on {}", (Object)new Object[]{string, requestData.getBaseUrl()}, (Object)exception);
            bl2 = true;
            inboundSmsBasicData = null;
        }
        if (inboundSmsBasicData == null || StringHelper.isBlank((Object)inboundSmsBasicData.getPhoneNumber()) || StringHelper.isBlank((Object)inboundSmsBasicData.getMessage())) {
            if (!bl2) {
                this.getLogger().info("Received an inbound sms request on {} which didn't pass in the number and / or message", (Object)requestData.getBaseUrl());
            }
            return this.generateResponseForMissingParameters(requestData, smsChannelConfiguration, inboundSmsRequestHandler);
        }
        try {
            executeSmsResult = this.executeSms(smsChannelConfiguration, requestData, inboundSmsBasicData);
        }
        catch (Exception exception) {
            this.getLogger().error("Error while executing an inbound SMS operation: " + String.valueOf(inboundSmsBasicData), (Throwable)exception);
            return this.generateResponseForOperationExecutionError(requestData, smsChannelConfiguration, inboundSmsRequestHandler, exception);
        }
        Long l = SimpleEntity.id((SimpleEntity)executeSmsResult.getMobilePhone());
        InboundSms inboundSms = executeSmsResult.getInboundSms();
        InboundSmsData inboundSmsData = executeSmsResult.getSmsData();
        this.saveInboundSmsLogAndReply(requestData, l, executeSmsResult);
        try {
            return this.generateResponseForOperationExecution(requestData, smsChannelConfiguration, inboundSmsRequestHandler, inboundSmsData, inboundSms);
        }
        catch (Exception exception) {
            this.getLogger().error("Error while generating the response for an inbound SMS operation: " + String.valueOf(inboundSmsData), (Throwable)exception);
            return this.generateResponseForOperationExecutionError(requestData, smsChannelConfiguration, inboundSmsRequestHandler, exception);
        }
    }

    private ExecuteSmsResult doExecuteSms(SmsChannelConfiguration smsChannelConfiguration, InboundSmsBasicData inboundSmsBasicData, RequestData requestData, TransactionStatus transactionStatus) {
        SessionData sessionData = InvocationContext.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        String string = inboundSmsBasicData.getPhoneNumber();
        QMobilePhone qMobilePhone = QMobilePhone.mobilePhone;
        final MobilePhone mobilePhone = (MobilePhone)((DBQuery)this.entityManagerHandler.from(new EntityPath[]{qMobilePhone}).where(new Predicate[]{qMobilePhone.normalizedNumber.eq((Object)string), qMobilePhone.user().status.eq((Object)UserStatus.ACTIVE)})).singleResult((Expression)qMobilePhone);
        InboundSms inboundSms = new InboundSms();
        inboundSms.setDate(new Date());
        inboundSms.setNetwork(sessionData.getNetwork());
        inboundSms.setConfigurationId(configurationAccessor.getConfiguration().getId());
        inboundSms.setPhoneNumber(inboundSmsBasicData.getPhoneNumber());
        inboundSms.setUser(mobilePhone == null || !mobilePhone.isEnabledForSms() ? null : mobilePhone.getUser());
        inboundSms.setMessage(inboundSmsBasicData.getMaskedMessage());
        InboundSmsData inboundSmsData = null;
        boolean bl = true;
        if (!(mobilePhone == null || mobilePhone.isEnabledForSms() && this.configurationHandler.getAccessor(mobilePhone.getUser()).isMobileUnique())) {
            inboundSms.setStatus(InboundSmsStatus.DISABLED_PHONE);
        } else {
            final Pair<SmsOperationConfiguration, InboundSmsData> pair = this.getOperationConfiguration(inboundSmsBasicData, smsChannelConfiguration);
            final SmsOperationConfiguration smsOperationConfiguration = (SmsOperationConfiguration)pair.getFirst();
            inboundSmsData = (InboundSmsData)pair.getSecond();
            if (smsOperationConfiguration == null) {
                inboundSms.setStatus(InboundSmsStatus.INVALID_OPERATION);
            } else {
                inboundSms.setOperationNature(smsOperationConfiguration.getNature());
                inboundSms.setOperationConfigurationId(smsOperationConfiguration.getId());
                inboundSms.setOperationAlias(inboundSmsData.getOperationAlias());
                if (this.isLogPlainMessage(smsOperationConfiguration)) {
                    inboundSms.setMessage(inboundSmsBasicData.getMessage());
                } else {
                    inboundSms.setMessage(inboundSmsData.getMaskedMessage());
                }
                final SmsOperation smsOperation = this.getSmsOperation(smsOperationConfiguration);
                SmsOperationExecution smsOperationExecution = smsOperation.getOperationExecution(smsOperationConfiguration);
                boolean bl2 = true;
                switch (smsOperationExecution) {
                    case ALL: {
                        break;
                    }
                    case ONLY_BY_GUESTS: {
                        if (mobilePhone == null) break;
                        inboundSms.setStatus(InboundSmsStatus.INVALID_OPERATION);
                        bl2 = false;
                        break;
                    }
                    case ONLY_BY_REGISTERED_USERS: {
                        if (mobilePhone != null) break;
                        inboundSms.setStatus(InboundSmsStatus.UNREGISTERED_PHONE);
                        bl2 = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown operation execution: " + String.valueOf(smsOperationExecution));
                    }
                }
                if (bl2) {
                    Object object = mobilePhone == null ? SessionDataFactory.guest((RequestData)requestData, (String)BuiltInChannel.SMS.getInternalName()) : SessionDataFactory.direct((UserPrincipal)mobilePhone).channel(BuiltInChannel.SMS).honorUrgentSituation(UrgentSituation.PENDING_AGREEMENT).build();
                    try {
                        object.checkConsistency();
                        this.invokerHandler.runAs(object, (Callable)new CallableRunnable(){

                            public void run() {
                                smsOperation.execute(smsOperationConfiguration, mobilePhone, (InboundSmsData)pair.getSecond());
                            }
                        });
                        inboundSms.setStatus(InboundSmsStatus.SUCCESS);
                    }
                    catch (SmsOperationException smsOperationException) {
                        this.getLogger().error("Error while executing inbound SMS operation " + String.valueOf(inboundSmsData), (Throwable)smsOperationException);
                        inboundSms.setStatus(InboundSmsStatus.ERROR);
                        transactionStatus.setRollbackOnly();
                        bl = false;
                    }
                    catch (InaccessibleChannelException inaccessibleChannelException) {
                        inboundSms.setStatus(InboundSmsStatus.INACCESSIBLE_CHANNEL);
                        transactionStatus.setRollbackOnly();
                        bl = false;
                    }
                    catch (RetryException retryException) {
                        throw retryException;
                    }
                    catch (Exception exception) {
                        this.getLogger().error("Error while executing inbound SMS operation " + String.valueOf(inboundSmsData), (Throwable)exception);
                        inboundSms.setStatus(InboundSmsStatus.ERROR);
                        transactionStatus.setRollbackOnly();
                    }
                }
            }
        }
        return new ExecuteSmsResult(mobilePhone, inboundSms, inboundSmsData, bl);
    }

    private ExecuteSmsResult executeSms(SmsChannelConfiguration smsChannelConfiguration, RequestData requestData, InboundSmsBasicData inboundSmsBasicData) {
        return (ExecuteSmsResult)this.invokerHandler.runAsInTransaction(this.sessionData(requestData), TransactionLevel.READ_WRITE, transactionStatus -> this.doExecuteSms(smsChannelConfiguration, inboundSmsBasicData, requestData, transactionStatus));
    }

    private ResponseInfo generateResponseForMissingParameters(RequestData requestData, SmsChannelConfiguration smsChannelConfiguration, InboundSmsRequestHandler inboundSmsRequestHandler) {
        return (ResponseInfo)this.invokerHandler.runAsInTransaction(this.sessionData(requestData), TransactionLevel.READ_WRITE, transactionStatus -> inboundSmsRequestHandler.generateResponseForMissingParameters(this.getSessionData().getConfiguration(), smsChannelConfiguration, requestData.getRequestInfo()));
    }

    private ResponseInfo generateResponseForOperationExecution(RequestData requestData, SmsChannelConfiguration smsChannelConfiguration, InboundSmsRequestHandler inboundSmsRequestHandler, InboundSmsData inboundSmsData, InboundSms inboundSms) {
        SessionData sessionData = this.sessionData(requestData);
        return (ResponseInfo)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_ONLY, transactionStatus -> inboundSmsRequestHandler.generateResponse(sessionData.getConfiguration(), smsChannelConfiguration, requestData.getRequestInfo(), inboundSmsData, inboundSms));
    }

    private ResponseInfo generateResponseForOperationExecutionError(RequestData requestData, SmsChannelConfiguration smsChannelConfiguration, InboundSmsRequestHandler inboundSmsRequestHandler, Exception exception) {
        SessionData sessionData = this.sessionData(requestData);
        return (ResponseInfo)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_ONLY, transactionStatus -> inboundSmsRequestHandler.generateResponseForError(this.getSessionData().getConfiguration(), smsChannelConfiguration, requestData.getRequestInfo(), exception));
    }

    private InboundSmsRequestHandler getInboundSmsRequestHandler(SmsChannelConfiguration smsChannelConfiguration) {
        CustomScript customScript = smsChannelConfiguration.getScript();
        if (customScript == null) {
            return (InboundSmsRequestHandler)this.beanHandler.getBean(InboundSmsRequestHandlerImpl.class);
        }
        return (InboundSmsRequestHandler)this.beanHandler.getBean(ScriptInboundSmsRequestHandlerImpl.class);
    }

    private Pair<SmsOperationConfiguration, InboundSmsData> getOperationConfiguration(InboundSmsBasicData inboundSmsBasicData, SmsChannelConfiguration smsChannelConfiguration) {
        if (CollectionHelper.isEmpty((Iterable)inboundSmsBasicData.getMessageParts())) {
            return Pair.create(null, null);
        }
        SmsOperationConfiguration smsOperationConfiguration = null;
        InboundSmsData inboundSmsData = null;
        Object[] objectArray = inboundSmsBasicData.getMessageParts().toArray(new String[inboundSmsBasicData.getMessageParts().size()]);
        for (int i = 1; i <= 3 && objectArray.length >= i; ++i) {
            String string = StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)i), (String)" ");
            QSmsOperationConfiguration qSmsOperationConfiguration = QSmsOperationConfiguration.smsOperationConfiguration;
            smsOperationConfiguration = (SmsOperationConfiguration)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qSmsOperationConfiguration}).where(new Predicate[]{qSmsOperationConfiguration.channelConfiguration().eq((Object)smsChannelConfiguration), qSmsOperationConfiguration.enabled.isTrue(), qSmsOperationConfiguration.aliases.contains((Object)string.toLowerCase())})).singleResult((Expression)qSmsOperationConfiguration);
            if (smsOperationConfiguration == null) continue;
            inboundSmsData = new InboundSmsData();
            inboundSmsData.setPhoneNumber(inboundSmsBasicData.getPhoneNumber());
            inboundSmsData.setMessage(inboundSmsBasicData.getMessage());
            inboundSmsData.setOperationAlias(string);
            inboundSmsData.setParameters(Arrays.asList((String[])ArrayUtils.subarray((Object[])objectArray, (int)i, (int)objectArray.length)));
            break;
        }
        return Pair.create(smsOperationConfiguration, inboundSmsData);
    }

    private boolean isLogPlainMessage(SmsOperationConfiguration smsOperationConfiguration) {
        if (smsOperationConfiguration instanceof WithPasswordSmsOperationConfiguration) {
            return !((WithPasswordSmsOperationConfiguration)smsOperationConfiguration).isUsePassword();
        }
        if (smsOperationConfiguration instanceof CustomSmsOperationConfiguration) {
            return ((CustomSmsOperationConfiguration)smsOperationConfiguration).isLogPlainSms();
        }
        if (smsOperationConfiguration instanceof RegisterSmsOperationConfiguration) {
            return !RegisterSmsOperation.isManualAccessPassword((RegisterSmsOperationConfiguration)smsOperationConfiguration, this.configurationHandler, this.channelService);
        }
        return true;
    }

    private String message(MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageKey, objectArray);
    }

    private Pair<SmsChannelConfiguration, InboundSmsRequestHandler> resolveSmsConfigurationAndHandler(RequestData requestData) {
        Pair pair = (Pair)this.invokerHandler.runAsInTransaction(this.sessionData(requestData), TransactionLevel.READ_WRITE, transactionStatus -> {
            SessionData sessionData = InvocationContext.getSessionData();
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            if (!configurationAccessor.isMobileUnique()) {
                return null;
            }
            Channel channel = this.channelService.getSms();
            SmsChannelConfiguration smsChannelConfiguration = (SmsChannelConfiguration)configurationAccessor.getChannelConfiguration(channel);
            if (smsChannelConfiguration == null || !smsChannelConfiguration.isEnabled()) {
                return null;
            }
            InboundSmsRequestHandler inboundSmsRequestHandler = this.getInboundSmsRequestHandler(smsChannelConfiguration);
            return Pair.create((Object)smsChannelConfiguration, (Object)inboundSmsRequestHandler);
        });
        return pair;
    }

    private InboundSmsBasicData resolveSmsData(RequestData requestData, SmsChannelConfiguration smsChannelConfiguration, InboundSmsRequestHandler inboundSmsRequestHandler) {
        return (InboundSmsBasicData)this.invokerHandler.runAsInTransaction(this.sessionData(requestData), TransactionLevel.READ_ONLY, transactionStatus -> inboundSmsRequestHandler.resolveSmsData(this.getSessionData().getConfiguration(), smsChannelConfiguration, requestData.getRequestInfo()));
    }

    private void saveInboundSmsLogAndReply(RequestData requestData, Long l, ExecuteSmsResult executeSmsResult) {
        InboundSms inboundSms = executeSmsResult.getInboundSms();
        this.invokerHandler.runAsInTransaction(this.sessionData(requestData), TransactionLevel.READ_WRITE, transactionStatus -> {
            this.entityManagerHandler.persist((IEntity)inboundSms);
            MobilePhone mobilePhone = l == null ? null : (MobilePhone)this.rawEntityManagerHandler.find(MobilePhone.class, l);
            String string = inboundSms.getPhoneNumber();
            ConfigurationAccessor configurationAccessor = null;
            if (mobilePhone == null) {
                Configuration configuration = (Configuration)this.rawEntityManagerHandler.find(Configuration.class, requestData.getConfigurationId());
                configurationAccessor = this.configurationHandler.getAccessor(configuration);
            }
            switch (inboundSms.getStatus()) {
                case DISABLED_PHONE: {
                    this.outboundSmsHandler.sendEvenIfDisabled(mobilePhone, this.message(MessagingKeys.Notifications.SMS_PHONE_DISABLED, new Object[0]), OutboundSmsType.SMS_OPERATION_RESPONSE);
                    break;
                }
                case INVALID_OPERATION: {
                    if (mobilePhone == null) {
                        this.outboundSmsHandler.sendToUnregistered(configurationAccessor, string, this.message(MessagingKeys.Notifications.SMS_TO_UNREGISTERED_PHONE, new Object[0]), OutboundSmsType.SMS_OPERATION_RESPONSE);
                        break;
                    }
                    this.outboundSmsHandler.sendEvenIfDisabled(mobilePhone, this.message(MessagingKeys.Notifications.SMS_INVALID_OPERATION, new Object[0]), OutboundSmsType.SMS_OPERATION_RESPONSE);
                    break;
                }
                case UNREGISTERED_PHONE: {
                    this.outboundSmsHandler.sendToUnregistered(configurationAccessor, string, this.message(MessagingKeys.Notifications.SMS_TO_UNREGISTERED_PHONE, new Object[0]), OutboundSmsType.SMS_OPERATION_RESPONSE);
                    break;
                }
                case ERROR: {
                    if (!executeSmsResult.isSendErrorResponse()) break;
                    if (mobilePhone == null) {
                        this.outboundSmsHandler.sendToUnregistered(configurationAccessor, string, this.message(MessagingKeys.Notifications.SMS_TO_UNREGISTERED_PHONE, new Object[0]), OutboundSmsType.SMS_OPERATION_RESPONSE);
                        break;
                    }
                    this.outboundSmsHandler.sendEvenIfDisabled(mobilePhone, this.message(MessagingKeys.Notifications.SMS_UNEXPECTED_ERROR, new Object[0]), OutboundSmsType.SMS_OPERATION_RESPONSE);
                    break;
                }
            }
            return null;
        });
    }

    private SessionData sessionData(RequestData requestData) {
        return SessionDataFactory.system((RequestData)requestData, (String)BuiltInChannel.SMS.getInternalName());
    }

    private class ExecuteSmsResult {
        private MobilePhone mobilePhone;
        private InboundSms inboundSms;
        private InboundSmsData smsData;
        private boolean sendErrorResponse;

        public ExecuteSmsResult(MobilePhone mobilePhone, InboundSms inboundSms, InboundSmsData inboundSmsData, boolean bl) {
            this.mobilePhone = mobilePhone;
            this.inboundSms = inboundSms;
            this.smsData = inboundSmsData;
            this.sendErrorResponse = bl;
        }

        public InboundSms getInboundSms() {
            return this.inboundSms;
        }

        public MobilePhone getMobilePhone() {
            return this.mobilePhone;
        }

        public InboundSmsData getSmsData() {
            return this.smsData;
        }

        public boolean isSendErrorResponse() {
            return this.sendErrorResponse;
        }
    }
}

