/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.system.WithPasswordSmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.InboundSmsParameterException;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.sms.SmsOperation;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsOperationFormatterImpl;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.CyclosException;
import org.cyclos.model.RetryException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.PasswordStatusException;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationExecution;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseSmsOperation
implements SmsOperation {
    @Autowired
    protected PasswordHandler passwordHandler;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    protected UserLocatorHandler userLocatorHandler;
    @Autowired
    protected OutboundSmsHandler outboundSmsHandler;
    @Autowired
    protected TranslationHandler translationHandler;
    @Autowired
    protected DataTranslationHandler dataTranslationHandler;
    @Autowired
    protected ConfigurationHandler configurationHandler;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired
    protected AccountHandler accountHandler;
    @Autowired
    protected ProfileFieldHandler profileFieldHandler;
    @Autowired
    protected EntityManagerHandler entityManagerHandler;
    @Autowired
    protected AgreementLogServiceLocal agreementLogService;

    public final void execute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData) throws SmsOperationException {
        try {
            this.checkParametersCount(smsOperationConfiguration, inboundSmsData.getParameters());
            SmsParameterProcessor smsParameterProcessor = this.parameterProcessor(smsOperationConfiguration, inboundSmsData.getParameters());
            SessionData sessionData = this.getSessionData();
            this.checkPassword(sessionData, smsOperationConfiguration, smsParameterProcessor);
            this.checkPendingAgreement(sessionData);
            this.doExecute(smsOperationConfiguration, mobilePhone, inboundSmsData, smsParameterProcessor);
        }
        catch (RetryException retryException) {
            throw retryException;
        }
        catch (Exception exception) {
            this.handleError(mobilePhone, inboundSmsData.getPhoneNumber(), smsOperationConfiguration, exception);
        }
    }

    public final String getHelp(SmsOperationConfiguration smsOperationConfiguration, String string) {
        List<String> list = this.getHelpComponents(smsOperationConfiguration);
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        arrayList.add(0, string);
        for (String string2 : list) {
            arrayList.add(string2.replace(' ', '_').toLowerCase());
        }
        return this.message(MessagingKeys.Notifications.SMS_HELP_RESPONSE_OPERATION_SYNTAX, StringUtils.join(arrayList, (String)" "));
    }

    public SmsOperationExecution getOperationExecution(SmsOperationConfiguration smsOperationConfiguration) {
        return SmsOperationExecution.ONLY_BY_REGISTERED_USERS;
    }

    protected abstract void checkParametersCount(SmsOperationConfiguration var1, List<String> var2) throws SmsOperationException;

    protected abstract void doExecute(SmsOperationConfiguration var1, MobilePhone var2, InboundSmsData var3, SmsParameterProcessor var4) throws CyclosException;

    protected String formatShort(AccountOwner accountOwner) {
        return this.getFormatter().format(accountOwner);
    }

    protected SmsOperationFormatterImpl getFormatter() {
        return new SmsOperationFormatterImpl(InvocationContext.getFormatter(null));
    }

    protected abstract List<String> getHelpComponents(SmsOperationConfiguration var1);

    protected String getLongestAlias(SmsOperationConfiguration smsOperationConfiguration) {
        String string = "";
        List list = smsOperationConfiguration.getAliases();
        for (String string2 : list) {
            if (string.length() >= string2.length()) continue;
            string = string2;
        }
        return string;
    }

    protected SessionData getSessionData() {
        return InvocationContext.getSessionData();
    }

    protected void handleError(MobilePhone mobilePhone, String string, SmsOperationConfiguration smsOperationConfiguration, Exception exception) throws SmsOperationException {
        Object object;
        Object[] objectArray;
        SmsOperationException smsOperationException = null;
        if (exception instanceof SmsOperationException) {
            smsOperationException = (SmsOperationException)((Object)exception);
        } else if (exception instanceof InboundSmsParameterException) {
            objectArray = (Object[])exception;
            smsOperationException = new SmsOperationException((Throwable)objectArray, (Object)BaseError.INVALID_PARAMETER.getMessageKey(), new Object[]{objectArray.getIdentifier(), objectArray.getValue()});
        } else {
            smsOperationException = exception instanceof ValidationException ? (StringHelper.isBlank((Object)(object = (objectArray = (ValidationException)exception).getValidation().getFirstError())) ? new SmsOperationException((Throwable)objectArray, (Object)BaseError.GENERAL_VALIDATION_ERROR.getMessageKey(), new Object[0]) : new SmsOperationException((Throwable)objectArray, (Object)BaseError.VALIDATION_ERROR.getMessageKey(), new Object[]{object})) : new SmsOperationException((Throwable)exception, (Object)MessagingKeys.Notifications.SMS_UNEXPECTED_ERROR, new Object[0]);
        }
        this.fill(smsOperationException, smsOperationConfiguration);
        objectArray = smsOperationException.getErrorParameters();
        object = smsOperationException.getError();
        Callable<String> callable = () -> {
            if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (!(object2 instanceof MessageKey)) continue;
                    objectArray[i] = this.translationHandler.message((MessageKey)object2, new Object[0]);
                }
            }
            String string = object instanceof MessageKey ? this.translationHandler.message((MessageKey)object, objectArray) : object.toString();
            return string;
        };
        SessionData sessionData = this.getSessionData();
        InvocationContext.get().addRollbackListener(true, () -> {
            String string2;
            SessionData sessionData2 = this.getSessionData();
            if (mobilePhone != null) {
                string2 = (MobilePhone)this.entityManagerHandler.find(MobilePhone.class, mobilePhone.getId());
                sessionData2 = SessionDataFactory.direct((UserPrincipal)string2).basedOn(sessionData).build();
            }
            string2 = (String)this.invokerHandler.runAs(sessionData2, callable);
            if (mobilePhone != null) {
                this.sendEvenIfDisabled(mobilePhone, string2);
            } else {
                this.sendToUnregistered(string, string2);
            }
        });
        throw smsOperationException;
    }

    protected String message(MessageKey messageKey, Object ... objectArray) {
        String string = this.translationHandler.message(MessageFormat.PLAIN, messageKey, objectArray);
        string = StringHelper.replace((String)string, (String)"<br>", (String)"\n");
        return string;
    }

    protected void sendEvenIfDisabled(MobilePhone mobilePhone, String string) {
        this.outboundSmsHandler.sendEvenIfDisabled(mobilePhone, string, OutboundSmsType.SMS_OPERATION_RESPONSE);
    }

    protected void sendResponse(MobilePhone mobilePhone, String string) {
        this.outboundSmsHandler.send(mobilePhone, string, OutboundSmsType.SMS_OPERATION_RESPONSE);
    }

    protected void sendToUnregistered(String string, String string2) {
        this.outboundSmsHandler.sendToUnregistered(this.getSessionData().getConfiguration(), string, string2, OutboundSmsType.SMS_OPERATION_RESPONSE);
    }

    private void checkPassword(SessionData sessionData, SmsOperationConfiguration smsOperationConfiguration, SmsParameterProcessor smsParameterProcessor) {
        boolean bl = false;
        if (smsOperationConfiguration instanceof WithPasswordSmsOperationConfiguration) {
            bl = ((WithPasswordSmsOperationConfiguration)smsOperationConfiguration).isUsePassword();
        }
        if (bl) {
            if (!sessionData.isLoggedIn()) {
                throw new IllegalStateException("Can't check password for guest. Operation: " + (String)smsOperationConfiguration.getAliases().get(0));
            }
            if (smsParameterProcessor.hasNext()) {
                PasswordType passwordType = smsOperationConfiguration.getChannelConfiguration().getAccessPassword();
                String string = this.dataTranslationHandler.getName((NamedEntity)passwordType);
                String string2 = smsParameterProcessor.nextString((Object)string);
                try {
                    this.passwordHandler.accessor(CredentialUsage.ACCESS).check(string2, null);
                }
                catch (PasswordException passwordException) {
                    PasswordStatus passwordStatus;
                    if (passwordException instanceof PasswordStatusException && ((passwordStatus = ((PasswordStatusException)passwordException).getPasswordStatus()) == PasswordStatus.EXPIRED || passwordStatus == PasswordStatus.RESET)) {
                        throw new SmsOperationException((Object)BaseError.EXPIRED_PASSWORD_ERROR.getMessageKey(), new Object[0]);
                    }
                    throw new SmsOperationException((Throwable)passwordException, (Object)BaseError.INVALID_PARAMETER.getMessageKey(), new Object[]{string, "****"});
                }
            } else {
                throw new SmsOperationException((Object)BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[0]);
            }
        }
    }

    private void checkPendingAgreement(SessionData sessionData) {
        sessionData.ifWraps(UserSessionData.class, userSessionData -> {
            if (userSessionData.hasPendingAgreements()) {
                throw new SmsOperationException((Object)BaseError.PENDING_AGREEMENT_ERROR.getMessageKey(), new Object[0]);
            }
        });
    }

    private void fill(SmsOperationException smsOperationException, SmsOperationConfiguration smsOperationConfiguration) {
        smsOperationException.addParameter((Object)this.getLongestAlias(smsOperationConfiguration));
    }

    private SmsParameterProcessor parameterProcessor(SmsOperationConfiguration smsOperationConfiguration, List<String> list) {
        return new SmsParameterProcessor(this.userLocatorHandler, smsOperationConfiguration, list);
    }

    protected static enum BaseError implements HasMessageKey
    {
        INVALID_PARAMETER(MessagingKeys.Notifications.SMS_INVALID_PARAMETER),
        INVALID_PARAMETERS_COUNT(MessagingKeys.Notifications.SMS_INVALID_PARAMETERS_COUNT),
        EXPIRED_PASSWORD_ERROR(MessagingKeys.Notifications.SMS_EXPIRED_PASSOWRD_ERROR),
        PENDING_AGREEMENT_ERROR(MessagingKeys.Notifications.SMS_PENDING_AGREEMENT_ERROR),
        GENERAL_VALIDATION_ERROR(MessagingKeys.Notifications.SMS_GENERAL_VALIDATION_ERROR),
        VALIDATION_ERROR(MessagingKeys.Notifications.SMS_VALIDATION_ERROR);

        private MessageKey key;

        private BaseError(MessageKey messageKey) {
            this.key = messageKey;
        }

        public MessageKey getMessageKey() {
            return this.key;
        }
    }
}

