/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.system.WithPasswordSmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.PaymentSmsOperation;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestDTO;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.security.Security;
import org.cyclos.services.banking.PaymentRequestService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class AcceptPaymentRequestSmsOperation
extends BaseSmsOperation {
    private static final Logger LOG = LogManager.getLogger(AcceptPaymentRequestSmsOperation.class);
    @Autowired
    @Security
    private PaymentRequestService paymentRequestService;
    @Autowired
    private PaymentRequestServiceLocal paymentRequestServiceLocal;
    @Autowired
    private AccountServiceLocal accountService;

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        int n;
        WithPasswordSmsOperationConfiguration withPasswordSmsOperationConfiguration = (WithPasswordSmsOperationConfiguration)smsOperationConfiguration;
        boolean bl = withPasswordSmsOperationConfiguration.isUsePassword();
        int n2 = n = bl ? 2 : 1;
        if (CollectionHelper.size(list) < n) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[]{n, n});
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        BigDecimal bigDecimal;
        InternalAccountOwner internalAccountOwner;
        LOG.debug(String.format("Executing SMS Accept payment request operation (user: %1$s, sms: %2$s)", mobilePhone.getUser().getUsername(), inboundSmsData));
        AcceptPaymentRequestDTO acceptPaymentRequestDTO = new AcceptPaymentRequestDTO();
        String string = smsParameterProcessor.nextString((Object)MessagingKeys.Notifications.SMS_ACCEPT_PAYMENT_REQUEST_PARAMETER_REQUEST_NUMBER);
        PaymentRequest paymentRequest = this.paymentRequestServiceLocal.getBySmsCode(string, mobilePhone.getUser().getUser());
        if (paymentRequest == null) {
            String string2 = this.message(BankingKeys.Transactions.PAYMENT_REQUEST_SMS_CODE_NOT_FOUND, string);
            throw new ValidationException(string2);
        }
        acceptPaymentRequestDTO.setPaymentRequest(new PaymentRequestVO(paymentRequest.getId()));
        PaymentTransferType paymentTransferType = (PaymentTransferType)paymentRequest.getType();
        PaymentRequestVO paymentRequestVO = null;
        try {
            paymentRequestVO = this.paymentRequestService.accept(acceptPaymentRequestDTO);
        }
        catch (TransferException transferException) {
            internalAccountOwner = paymentRequest.getFromOwner();
            bigDecimal = paymentRequest.getCurrencyAmount().getAmount();
            PaymentSmsOperation.handleTransferException((AccountOwner)internalAccountOwner, bigDecimal, transferException, this.getFormatter(), paymentTransferType);
        }
        AccountType accountType = paymentTransferType.getFrom();
        internalAccountOwner = this.accountService.load((InternalAccountOwner)mobilePhone.getUser(), accountType);
        bigDecimal = this.accountService.getAvailableBalance((Account)internalAccountOwner, null);
        boolean bl = paymentTransferType.getCurrency().isTransactionNumberEnabled();
        Object[] objectArray = new Object[]{paymentTransferType, this.formatShort((AccountOwner)paymentRequestVO.getTo().getOwner()), paymentRequestVO.getCurrencyAmount(), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal), bl ? this.message(MessagingKeys.Notifications.TRANSACTION_NUMBER, paymentRequestVO.getTransactionNumber()) : ""};
        if (paymentRequestVO.getTransaction().getAuthorizationStatus() == TransactionAuthorizationStatus.PENDING_AUTHORIZATION) {
            this.sendResponse(mobilePhone, this.message(MessagingKeys.Notifications.SMS_ACCEPT_PAYMENT_REQUEST_RESPONSE_PENDING_AUTHORIZATION, objectArray));
        } else {
            this.sendResponse(mobilePhone, this.message(MessagingKeys.Notifications.SMS_ACCEPT_PAYMENT_REQUEST_RESPONSE_SUCCESSFULLY, objectArray));
        }
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        WithPasswordSmsOperationConfiguration withPasswordSmsOperationConfiguration = (WithPasswordSmsOperationConfiguration)smsOperationConfiguration;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (withPasswordSmsOperationConfiguration.isUsePassword()) {
            PasswordType passwordType = smsOperationConfiguration.getChannelConfiguration().getAccessPassword();
            arrayList.add(this.dataTranslationHandler.getName((NamedEntity)passwordType));
        }
        arrayList.add(this.message(MessagingKeys.Notifications.SMS_ACCEPT_PAYMENT_REQUEST_PARAMETER_REQUEST_NUMBER, new Object[0]));
        return arrayList;
    }
}

