/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import java.util.Date;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.messaging.Alert;
import org.cyclos.entities.messaging.ErrorLog;
import org.cyclos.entities.messaging.SystemAlert;
import org.cyclos.entities.messaging.UserAlert;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.UserImportedFile;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.utils.formatting.FormattedDate;
import org.cyclos.impl.utils.notifications.AdminNotificationsHandler;
import org.cyclos.impl.utils.notifications.NotificationDateFormat;
import org.cyclos.impl.utils.notifications.NotificationHandlerImpl;
import org.cyclos.impl.utils.notifications.NotificationURL;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AdminNotificationsHandlerImpl
extends BaseNetworkedHandlerImpl
implements AdminNotificationsHandler {
    @Autowired
    private NotificationHandlerImpl notificationsHandler;
    @Autowired
    @Lazy
    private AlertServiceLocal alertService;

    public void adPendingAuthorization(BasicAd basicAd) {
        this.notificationsHandler.notify(AdminNotificationType.AD_PENDING_AUTHORIZATION, (NetworkedEntity)basicAd, new NotificationURL(Location.ADVERTISEMENT, (SimpleEntity)basicAd), basicAd.getOwner(), basicAd.getOwner());
    }

    public void applicationError(ErrorLog errorLog) {
        this.notificationsHandler.notify(AdminNotificationType.APPLICATION_ERROR, (NetworkedEntity)errorLog, new NotificationURL(Location.ERROR_LOG, (SimpleEntity)errorLog), null, errorLog.getMethod());
    }

    public void externalPaymentExpired(ExternalPayment externalPayment, String string) {
        this.notificationsHandler.notify(AdminNotificationType.EXTERNAL_PAYMENT_EXPIRED, (NetworkedEntity)externalPayment, new NotificationURL(externalPayment.getLocation(), (SimpleEntity)externalPayment), externalPayment.getFromUser(), externalPayment.getDate(), externalPayment.getCurrencyAmount(), externalPayment.getType(), string);
    }

    public void externalPaymentPerformedFailed(ExternalPayment externalPayment, String string) {
        this.notificationsHandler.notify(AdminNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED, (NetworkedEntity)externalPayment, new NotificationURL(externalPayment.getLocation(), (SimpleEntity)externalPayment), externalPayment.getFromUser(), externalPayment.getDate(), externalPayment.getCurrencyAmount(), externalPayment.getType(), string);
    }

    public void generatedVouchersAboutToExpire(Voucher voucher, int n) {
        Date date = (Date)ObjectHelper.defaultValue((Object)voucher.getExpirationDate(), (Object)voucher.getPack().getExpirationDate());
        this.notificationsHandler.notify(AdminNotificationType.GENERATED_VOUCHERS_ABOUT_TO_EXPIRE, (NetworkedEntity)voucher, new NotificationURL(Location.VOUCHER, (SimpleEntity)voucher), null, voucher.getCurrencyAmount(), n, voucher.getType(), new FormattedDate(date, NotificationDateFormat.DATE_DIFF), new FormattedDate(voucher.getPack().getCreationDate(), NotificationDateFormat.DATE));
    }

    public void generatedVouchersExpired(Voucher voucher, int n) {
        this.notificationsHandler.notify(AdminNotificationType.GENERATED_VOUCHERS_EXPIRED, (NetworkedEntity)voucher, new NotificationURL(Location.VOUCHER, (SimpleEntity)voucher), null, voucher.getCurrencyAmount(), n, voucher.getType());
    }

    public void networkCreated(Network network) {
        this.notificationsHandler.notify(AdminNotificationType.NETWORK_CREATED, (NetworkedEntity)network, new NotificationURL(Location.NETWORK, (SimpleEntity)network), null, network.getName());
    }

    public void paymentAwaitingAuthorization(Transaction transaction) {
        this.notificationsHandler.notify(AdminNotificationType.PAYMENT_AWAITING_AUTHORIZATION, (NetworkedEntity)transaction, new NotificationURL(transaction.getLocation(), (SimpleEntity)transaction), transaction.getFromUser(), transaction.getCurrencyAmount(), transaction.getFromOwner());
    }

    public void paymentPerformed(Transaction transaction) {
        this.notificationsHandler.notify(AdminNotificationType.PAYMENT_PERFORMED, (NetworkedEntity)transaction, new NotificationURL(transaction.getLocation(), (SimpleEntity)transaction), transaction.getFromUser(), transaction.getCurrencyAmount(), transaction.getFromOwner());
    }

    public void systemAlert(SystemAlert systemAlert) {
        boolean bl = systemAlert.getType() == SystemAlertType.EMAIL_SENDING_FAILED;
        boolean bl2 = systemAlert.getType() == SystemAlertType.SMS_SENDING_FAILED;
        Object[] objectArray = this.alertService.resolveArguments((Alert)systemAlert);
        this.notificationsHandler.notifyWithSkip(AdminNotificationType.SYSTEM_ALERT, (NetworkedEntity)systemAlert, new NotificationURL(Location.SYSTEM_ALERT, (SimpleEntity)systemAlert), null, bl, bl2, new TranslationMessageSpecification(systemAlert.getType().getMessageKey(), objectArray), new TranslationMessageSpecification(systemAlert.getType().keyForText(), objectArray));
    }

    public void userAlert(UserAlert userAlert) {
        Object[] objectArray = this.alertService.resolveArguments((Alert)userAlert);
        this.notificationsHandler.notify(AdminNotificationType.USER_ALERT, (NetworkedEntity)userAlert, new NotificationURL(Location.USER_ALERT, (SimpleEntity)userAlert), userAlert.getUser(), new TranslationMessageSpecification(userAlert.getType().getMessageKey(), objectArray), new TranslationMessageSpecification(userAlert.getType().keyForText(), objectArray), userAlert.getUser(), userAlert.getUser());
    }

    public void userImportRegistration(UserImportedFile userImportedFile, int n, UserGroup userGroup) {
        this.notificationsHandler.notify(AdminNotificationType.USER_IMPORT_REGISTRATION, (NetworkedEntity)userGroup, new NotificationURL(Location.IMPORTS, (SimpleEntity)userImportedFile), null, n, userGroup);
    }

    public void userRegistration(User user) {
        this.notificationsHandler.notify(AdminNotificationType.USER_REGISTRATION, (NetworkedEntity)user.getGroup(), new NotificationURL(Location.NEW_USER, (SimpleEntity)user), user, user, user.getGroup(), user.getUsername());
    }

    public void voucherBuyingAboutToExpire(VoucherType voucherType, Date date) {
        this.notificationsHandler.notify(AdminNotificationType.VOUCHER_BUYING_ABOUT_TO_EXPIRE, (NetworkedEntity)voucherType, new NotificationURL(Location.VOUCHER_TYPE, (SimpleEntity)voucherType), null, voucherType, new FormattedDate(date, NotificationDateFormat.DATE_DIFF));
    }
}

