/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.jackson;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EntityType;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.utils.jackson.EntityDeserializer;
import org.cyclos.impl.utils.jackson.EntitySerializer;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class ImplJacksonConfiguration
extends JacksonConfiguration {
    @Autowired
    private EntityManagerFactory entityManagerFactory;
    @Autowired
    @Lazy
    private RawEntityManagerHandler rawEntityManagerHandler;

    public void configure(ObjectMapper objectMapper) {
        super.configure(objectMapper);
        SimpleModule simpleModule = new SimpleModule("Entities");
        this.configureModule(simpleModule);
        objectMapper.registerModule((Module)simpleModule);
    }

    private void configureModule(SimpleModule simpleModule) {
        SimpleDeserializers simpleDeserializers = new SimpleDeserializers();
        Set set = this.entityManagerFactory.getMetamodel().getEntities();
        for (EntityType entityType : set) {
            Class clazz = entityType.getJavaType();
            if (!SimpleEntity.class.isAssignableFrom(clazz)) continue;
            Class clazz2 = clazz;
            simpleDeserializers.addDeserializer(clazz2, new EntityDeserializer(clazz2, this.rawEntityManagerHandler));
        }
        simpleModule.setDeserializers(simpleDeserializers);
        SimpleSerializers simpleSerializers = new SimpleSerializers();
        simpleSerializers.addSerializer((JsonSerializer)new EntitySerializer());
        simpleModule.setSerializers(simpleSerializers);
    }
}

