/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.formatting;

import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.formatting.ValueFormatter;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.PredefinedPeriodData;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Month;

public class PredefinedPeriodDataValueFormatter
implements ValueFormatter {
    private static final PredefinedPeriodDataValueFormatter INSTANCE = new PredefinedPeriodDataValueFormatter();

    public static PredefinedPeriodDataValueFormatter instance() {
        return INSTANCE;
    }

    private PredefinedPeriodDataValueFormatter() {
    }

    @Override
    public String format(Object object, Object object2, FormatterImpl formatterImpl) {
        if (object2 instanceof PredefinedPeriodData) {
            TranslationHandler translationHandler = formatterImpl.getTranslationHandler();
            PredefinedPeriodData predefinedPeriodData = (PredefinedPeriodData)object2;
            if (predefinedPeriodData.getYear() == null || predefinedPeriodData.getType() == null) {
                return translationHandler.message(SystemKeys.Reports.SYSTEM_PERIOD_SPECIFY_OTHER, new Object[0]);
            }
            switch (predefinedPeriodData.getType()) {
                case YEAR: {
                    return "" + predefinedPeriodData.getYear();
                }
                case QUARTER: {
                    return translationHandler.message(GeneralKeys.Ui.QUARTER_FORMAT, new Object[]{"" + predefinedPeriodData.getYear(), predefinedPeriodData.getQuarter()});
                }
                case MONTH: {
                    Month month = Month.values()[predefinedPeriodData.getMonth()];
                    MessageKey messageKey = month.getMessageKey();
                    return translationHandler.message(GeneralKeys.Ui.MONTH_YEAR, new Object[]{translationHandler.message(messageKey, new Object[0]), "" + predefinedPeriodData.getYear()});
                }
                case MONTH_RANGE: {
                    int n = predefinedPeriodData.getMonth();
                    MessageKey messageKey = n == 1 ? GeneralKeys.Ui.LAST_MONTH : GeneralKeys.Ui.LAST_MONTHS;
                    return translationHandler.message(messageKey, new Object[]{n});
                }
                case WEEK_OF_YEAR: {
                    return predefinedPeriodData.getYear() + " " + translationHandler.message(GeneralKeys.Ui.TIME_FIELD_SINGULAR_WEEKS, new Object[0]) + " " + predefinedPeriodData.getWeek();
                }
                case DAY: {
                    return formatterImpl.format((IDate)new DateTime(predefinedPeriodData.getYear().intValue(), predefinedPeriodData.getMonth().intValue(), predefinedPeriodData.getDay().intValue()));
                }
                case CURRENT_DAY: {
                    return translationHandler.message(GeneralKeys.Ui.TODAY, new Object[0]);
                }
                case CURRENT_WEEK: {
                    return translationHandler.message(GeneralKeys.Ui.THIS_WEEK, new Object[0]);
                }
            }
        }
        return "";
    }
}

