/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.conversion;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.AbstractBeanConverter;
import org.cyclos.server.utils.SerializableInputStream;
import org.springframework.stereotype.Component;

@Component
public class SerializableInputStreamConverter
extends AbstractBeanConverter<SerializableInputStream> {
    public SerializableInputStreamConverter() {
        super(SerializableInputStream.class);
    }

    @Override
    public SerializableInputStream convert(Class<SerializableInputStream> clazz, Object object, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object == null || object instanceof SerializableInputStream) {
            return (SerializableInputStream)object;
        }
        if (object instanceof InputStream) {
            return new SerializableInputStream((InputStream)object);
        }
        if (object instanceof Blob) {
            try {
                return new SerializableInputStream((Blob)object);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        if (object instanceof byte[]) {
            return new SerializableInputStream((byte[])object);
        }
        if (object instanceof File) {
            try {
                return new SerializableInputStream((InputStream)new FileInputStream((File)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return new SerializableInputStream(object.toString().getBytes(Charsets.UTF_8));
    }
}

