/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.conversion;

import java.util.HashMap;
import java.util.Map;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.utils.conversion.AbstractBeanConverter;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.utils.ModelHelper;
import org.springframework.stereotype.Component;

@Component
public class ObjectConverter<T>
extends AbstractBeanConverter<T> {
    private Map<Class<?>, Class<?>> subClassMapping = null;

    public ObjectConverter() {
        super(Object.class);
        if (!this.getClass().equals(ObjectConverter.class)) {
            throw new IllegalArgumentException("Subclasses are not meant to use the default constructor");
        }
    }

    public ObjectConverter(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public T convert(Class<T> clazz, Object object, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        T t;
        Class<T> clazz2 = this.resolveDestinationType(clazz, object, conversionContext);
        try {
            t = this.instantiate(clazz2, object, conversionContext);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            EntityVO entityVO;
            if (object instanceof EntityVO && (entityVO = (EntityVO)object).getId() == null && entityNotFoundException.getId() != null) {
                entityNotFoundException.setId(null);
                entityNotFoundException.setKey(ModelHelper.stringFromVO((EntityVO)entityVO));
            }
            throw entityNotFoundException;
        }
        if (t != null) {
            this.fill(object, t, objectArray, conversionContext);
        }
        return t;
    }

    protected void fill(Object object, T t, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (this.canBeUsedAsSourceForFilling(object)) {
            this.conversionHandler.fill(object, t, objectArray, conversionContext);
        }
    }

    @Override
    protected SessionData getSessionData() {
        return InvocationContext.getSessionData();
    }

    protected T instantiate(Class<T> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        return (T)this.beanHandler.instantiate(clazz);
    }

    protected void registerMapping(Class<?> clazz, Class<?> clazz2) {
        if (this.subClassMapping == null) {
            this.subClassMapping = new HashMap();
        }
        this.subClassMapping.put(clazz, clazz2);
    }

    protected Class<T> resolveDestinationType(Class<T> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        if (this.subClassMapping != null && object != null) {
            Class<?> clazz2 = null;
            for (Class<?> clazz3 = object.getClass(); clazz2 == null && clazz3 != null; clazz3 = clazz3.getSuperclass()) {
                clazz2 = this.subClassMapping.get(clazz3);
            }
            if (clazz2 != null) {
                return clazz2;
            }
        }
        return clazz;
    }
}

