/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.conversion;

import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.AbstractBeanConverter;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionException;
import org.springframework.stereotype.Component;

@Component
public class DateTimeConverter
extends AbstractBeanConverter<DateTime> {
    public DateTimeConverter() {
        super(DateTime.class);
    }

    @Override
    public DateTime convert(Class<DateTime> clazz, Object object, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        Serializable serializable;
        ZoneId zoneId = this.getSessionData().getConfiguration().getTimeZone().toZoneId();
        Instant instant = null;
        if (object instanceof OffsetDateTime) {
            serializable = (OffsetDateTime)object;
            instant = ((OffsetDateTime)serializable).toInstant();
        } else if (object instanceof ZonedDateTime) {
            serializable = (ZonedDateTime)object;
            instant = serializable.toInstant();
        } else if (object instanceof Calendar) {
            serializable = (Calendar)object;
            instant = ((Calendar)serializable).toInstant();
        } else if (object instanceof Date) {
            serializable = (Date)object;
            instant = ((Date)serializable).toInstant();
        } else if (object instanceof DateWrapper) {
            serializable = ((DateWrapper)object).getDate();
            instant = ((Date)serializable).toInstant();
        } else if (object instanceof Number) {
            serializable = (Number)object;
            instant = Instant.ofEpochMilli(((Number)serializable).longValue());
        } else {
            try {
                return DateTime.parse((String)StringHelper.trimToNull((Object)object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (instant == null) {
            throw new CoercionException(StringHelper.trimToNull((Object)object));
        }
        serializable = ZonedDateTime.ofInstant(instant, zoneId);
        return new DateTime(serializable);
    }
}

