/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.conversion;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.AbstractBeanConverter;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionException;
import org.springframework.stereotype.Component;

@Component
public class DateConverter
extends AbstractBeanConverter<Date> {
    public DateConverter() {
        super(Date.class);
    }

    @Override
    public Date convert(Class<Date> clazz, Object object, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof DateTime) {
            DateTime dateTime = (DateTime)object;
            return this.toDate(dateTime);
        }
        if (object instanceof DateWrapper) {
            return ((DateWrapper)object).getDate();
        }
        if (object instanceof Date) {
            return new Date(((Date)object).getTime());
        }
        if (object instanceof OffsetDateTime) {
            return Date.from(((OffsetDateTime)object).toInstant());
        }
        if (object instanceof Number) {
            return new Date(((Number)object).longValue());
        }
        String string = StringHelper.trimToNull((Object)object);
        try {
            DateTime dateTime = DateTime.parse((String)string);
            return dateTime == null ? null : this.toDate(dateTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CoercionException(string, (Throwable)illegalArgumentException);
        }
    }

    private Date toDate(DateTime dateTime) {
        ZoneId zoneId = dateTime.getTimeZone() == null ? this.getSessionData().getConfiguration().getTimeZone().toZoneId() : ZoneId.of(dateTime.getTimeZone());
        LocalDateTime localDateTime = LocalDateTime.of(dateTime.getYear(), dateTime.getMonth() + 1, dateTime.getDate(), dateTime.getHours(), dateTime.getMinutes(), dateTime.getSeconds(), dateTime.getMilliseconds() * 1000000);
        Instant instant = localDateTime.atZone(zoneId).toInstant();
        return new Date(instant.toEpochMilli());
    }
}

