/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cyclos.impl.utils.cache.AbstractCache;
import org.cyclos.impl.utils.cache.CacheHandlerImplementor;
import org.cyclos.impl.utils.cache.CacheType;

public class GuavaCache<K extends Serializable, V>
extends AbstractCache<K, V> {
    private Cache<K, V> cache;

    private GuavaCache(CacheHandlerImplementor cacheHandlerImplementor, CacheType<K, V> cacheType) {
        super(cacheHandlerImplementor, cacheType);
    }

    @Override
    public void destroy() {
        try {
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean contains(K k) {
        return this.cache.getIfPresent(k) != null;
    }

    @Override
    protected void doClear() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing cache {}", (Object)this.getType().getName());
        }
        this.cache.invalidateAll();
    }

    @Override
    protected void doEvict(Collection<K> collection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evicting cache {}, keys {}", (Object)this.getType().getName(), collection);
        }
        this.cache.invalidateAll(collection);
    }

    @Override
    protected V doGet(K k, Callable<V> callable) {
        try {
            return (V)this.cache.get(k, callable);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            Throwable throwable = uncheckedExecutionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException("Couldn't obtain cached value", throwable);
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException("Couldn't obtain cached value", executionException);
        }
    }

    @Override
    protected long doSize() {
        return this.cache.size();
    }

    @Override
    protected Collection<K> getKeys(Predicate<K> predicate) {
        return this.cache.asMap().keySet().stream().filter(predicate).collect(Collectors.toSet());
    }

    private void initialize(Cache<K, V> cache) {
        this.cache = cache;
    }

    static class Builder<K extends Serializable, V> {
        private CacheType<K, V> type;
        private CacheHandlerImplementor cacheHandler;
        private GuavaCache<K, V> cache;

        Builder(CacheHandlerImplementor cacheHandlerImplementor, CacheType<K, V> cacheType) {
            this.cacheHandler = cacheHandlerImplementor;
            this.type = cacheType;
        }

        GuavaCache<K, V> build(Cache<K, V> cache) {
            this.cache.initialize(cache);
            return this.cache;
        }

        AbstractCache.EvictListener getEvictListener() {
            if (this.cache == null) {
                this.cache = new GuavaCache<K, V>(this.cacheHandler, this.type);
            }
            return this.cache.getEvictListener();
        }
    }
}

