/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandlerImplementor;
import org.cyclos.impl.utils.cache.CacheOperation;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cache.CustomCache;
import org.cyclos.utils.CollectionHelper;

public abstract class CacheHandlerImpl
implements CacheHandlerImplementor {
    private boolean skipCache;
    private ConcurrentMap<CacheType<? extends Serializable, ?>, Cache<? extends Serializable, ?>> caches = new ConcurrentHashMap();

    public void apply(TreeMap<CacheType<? extends Serializable, ?>, CacheOperation> treeMap) {
        treeMap.entrySet().stream().forEachOrdered(entry -> {
            Cache cache = this.getCacheIfInitialized((CacheType)entry.getKey());
            ((CacheOperation)entry.getValue()).run(cache);
        });
    }

    public void clearAll() {
        CacheType.all().stream().map(this::getCacheIfInitialized).filter(Objects::nonNull).forEach(Cache::clear);
    }

    public CustomCache custom(String string) {
        final CacheType cacheType = CacheType.custom((String)string);
        final Cache cache = this.getCache(cacheType);
        return new CustomCache(){

            public void clear() {
                CacheHandlerImpl.this.scheduleClear(cacheType);
            }

            public void evict(Serializable ... serializableArray) {
                int n = CollectionHelper.size((Object[])serializableArray);
                switch (n) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        CacheHandlerImpl.this.scheduleEvict(cacheType, serializableArray[0]);
                        break;
                    }
                    default: {
                        CacheHandlerImpl.this.scheduleEvict(cacheType, Stream.of(serializableArray).collect(Collectors.toSet()));
                    }
                }
            }

            public Object get(Serializable serializable, Supplier<Object> supplier) {
                return cache.get(serializable, supplier::get);
            }
        };
    }

    @PreDestroy
    public void destroy() {
        for (Cache cache : this.caches.values()) {
            try {
                cache.destroy();
            }
            catch (Exception exception) {}
        }
        this.caches.clear();
    }

    public <K extends Serializable, V> Cache<K, V> getCache(CacheType<K, V> cacheType) {
        Cache<K, V> cache;
        Cache<K, V> cache2 = (Cache<K, V>)this.caches.get(cacheType);
        if (cache2 == null && (cache2 = this.caches.putIfAbsent(cacheType, cache = this.initCache(cacheType))) == null) {
            cache2 = cache;
        }
        return cache2;
    }

    public <K extends Serializable, V> Cache<K, V> getCacheIfInitialized(CacheType<K, V> cacheType) {
        return (Cache)this.caches.get(cacheType);
    }

    public boolean isSkipCache() {
        return this.skipCache;
    }

    public <K extends Serializable, V> void scheduleClear(CacheType<K, V> cacheType) {
        InvocationContext.ensure().clearCache(cacheType);
    }

    public <K extends Serializable, V> void scheduleEvict(CacheType<K, V> cacheType, K k) {
        InvocationContext.ensure().evictCacheKeys(cacheType, Collections.singleton(k));
    }

    public <K extends Serializable, V> void scheduleEvict(CacheType<K, V> cacheType, Set<K> set) {
        InvocationContext.ensure().evictCacheKeys(cacheType, set);
    }

    public <K extends Serializable, V> void schedulePartialEvict(CacheType<K, V> cacheType, SerializablePredicate<K> serializablePredicate) {
        InvocationContext.ensure().evictCacheKeyPredicate(cacheType, serializablePredicate);
    }

    public void setSkipCache(boolean bl) {
        this.skipCache = bl;
    }

    protected abstract <K extends Serializable, V> Cache<K, V> initCache(CacheType<K, V> var1);
}

