/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandlerImplementor;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.model.utils.CacheStatsVO;
import org.cyclos.utils.CollectionHelper;

public abstract class AbstractCache<K extends Serializable, V>
implements Cache<K, V> {
    protected static final Logger LOG = LogManager.getLogger(AbstractCache.class);
    protected final CacheType<K, V> type;
    protected AtomicLong hitCount;
    protected AtomicLong missCount;
    protected AtomicLong evictionCount;
    protected EvictListener evictListener;
    protected final CacheHandlerImplementor cacheHandler;
    protected ConcurrentHashMap<K, ProducerWrapper<K, V>> pendingProducers;
    protected ReadWriteLock rwLock;

    public AbstractCache(CacheHandlerImplementor cacheHandlerImplementor, CacheType<K, V> cacheType) {
        this.type = cacheType;
        this.cacheHandler = cacheHandlerImplementor;
        this.pendingProducers = new ConcurrentHashMap();
        this.hitCount = new AtomicLong();
        this.missCount = new AtomicLong();
        this.evictionCount = new AtomicLong();
        this.rwLock = new ReentrantReadWriteLock();
        this.evictListener = n -> this.add(this.evictionCount, n);
    }

    public final void clear() {
        this.pendingProducers.forEach((serializable, producerWrapper) -> producerWrapper.invalidate(true));
        this.doClear();
        this.resetStats();
    }

    public void destroy() {
    }

    public final void evict(Collection<K> collection) {
        this.evict(collection, false);
    }

    public void evict(Predicate<K> predicate) {
        Collection<K> collection = this.getKeys(predicate);
        this.evict(collection, true);
    }

    public final V get(K k, Callable<V> callable) {
        Object object;
        boolean bl = this.cacheHandler.isSkipCache();
        if (!bl) {
            object = InvocationContext.get();
            boolean bl2 = bl = object != null && object.isEvicted(this.getType(), k);
        }
        if (bl) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error while producing a cache value", exception);
            }
        }
        try {
            object = new ProducerWrapper(callable);
            this.pendingProducers.put(k, (ProducerWrapper<K, Object>)object);
            V v = this.doGet(k, (Callable<V>)object);
            if (((ProducerWrapper)object).isInvalid()) {
                this.doEvict(Collections.singleton(k));
                if (!((ProducerWrapper)object).invalidatedByClear()) {
                    this.increment(this.missCount);
                }
            } else if (((ProducerWrapper)object).isValueProduced()) {
                LOG.debug("Miss for cache {}: {}", this.type, k);
                this.increment(this.missCount);
            } else {
                LOG.trace("Hit for cache {}: {}", this.type, k);
                this.increment(this.hitCount);
            }
            V v2 = v;
            return v2;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalStateException("Couldn't obtain cached value from underlying cache implementation", exception);
        }
        finally {
            this.pendingProducers.remove(k);
        }
    }

    public EvictListener getEvictListener() {
        return this.evictListener;
    }

    public CacheStatsVO getStats() {
        double d = this.hitCount.longValue() == 0L ? 0.0 : this.hitCount.doubleValue() / (this.hitCount.doubleValue() + this.missCount.doubleValue());
        CacheStatsVO cacheStatsVO = new CacheStatsVO();
        cacheStatsVO.setHitRate(d);
        cacheStatsVO.setSize(Long.toString(this.doSize()));
        cacheStatsVO.setRequestCount(Long.toString(this.hitCount.longValue() + this.missCount.longValue()));
        cacheStatsVO.setEvictionCount(Long.toString(this.evictionCount.longValue()));
        return cacheStatsVO;
    }

    public final CacheType<K, V> getType() {
        return this.type;
    }

    protected abstract boolean contains(K var1);

    protected abstract void doClear();

    protected abstract void doEvict(Collection<K> var1);

    protected abstract V doGet(K var1, Callable<V> var2);

    protected abstract long doSize();

    protected abstract Collection<K> getKeys(Predicate<K> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(AtomicLong atomicLong, long l) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            atomicLong.addAndGet(l);
        }
        finally {
            lock.unlock();
        }
    }

    private void evict(Collection<K> collection, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache {}: Evicting {}: {}", this.type, (Object)(bl ? "by predicate" : "keys"), collection);
        }
        if (CollectionHelper.isEmpty(collection)) {
            return;
        }
        collection.forEach(serializable -> {
            ProducerWrapper<K, V> producerWrapper = this.pendingProducers.get(serializable);
            if (producerWrapper != null) {
                producerWrapper.invalidate(false);
            }
        });
        this.doEvict(collection);
        this.evictListener.evict(collection.size());
    }

    private void increment(AtomicLong atomicLong) {
        this.add(atomicLong, 1L);
    }

    private void resetStats() {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.hitCount.set(0L);
            this.missCount.set(0L);
            this.evictionCount.set(0L);
        }
        finally {
            lock.unlock();
        }
    }

    @FunctionalInterface
    static interface EvictListener {
        public void evict(int var1);
    }

    private class ProducerWrapper<K, V>
    implements Callable<V> {
        private final Callable<V> producer;
        private boolean valueProduced;
        private boolean invalid;
        private boolean invalidatedByClear;

        public ProducerWrapper(Callable<V> callable) {
            this.producer = callable;
        }

        @Override
        public V call() throws Exception {
            this.valueProduced = true;
            RequestContext requestContext = RequestContext.get();
            ProfilingEntry profilingEntry = requestContext == null ? null : requestContext.getProfilingEntry();
            long l = System.currentTimeMillis();
            V v = this.producer.call();
            if (profilingEntry != null) {
                profilingEntry.addCacheProducing(AbstractCache.this.type.getName(), (int)(System.currentTimeMillis() - l));
            }
            return v;
        }

        public void invalidate(boolean bl) {
            this.invalid = true;
            this.invalidatedByClear = bl;
        }

        public boolean invalidatedByClear() {
            return this.invalidatedByClear;
        }

        public boolean isInvalid() {
            return this.valueProduced && this.invalid;
        }

        public boolean isValueProduced() {
            return this.valueProduced;
        }
    }
}

