/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.appnotifications;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.AndroidNotification;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.MulticastMessage;
import com.google.firebase.messaging.Notification;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUserFcmToken;
import org.cyclos.entities.users.UserFcmToken;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.LocalStorage;
import org.cyclos.impl.utils.appnotifications.AppNotificationHandler;
import org.cyclos.impl.utils.appnotifications.AppNotificationMessage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.LocalStorageType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.ValidationException;
import org.cyclos.model.utils.AppNotificationException;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppNotificationHandlerImpl
extends BaseNetworkedHandlerImpl
implements AppNotificationHandler {
    private static final String CUSTOM_URL_APP_NOTIFICATION_PAYLOAD = "customUrl";
    private static final String USER_ID_APP_NOTIFICATION_PAYLOAD = "userId";
    private static final String[] TOKEN_RELATED_ERRORS = new String[]{"invalid-argument", "invalid-registration-token", "registration-token-not-registered"};
    @Autowired
    private ClusterHandler clusterHandler;
    private LocalStorage<String, FirebaseApp> instances;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private InvokerHandler invokerHandler;

    public boolean canReceiveNotifications(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        return this.isEnabled(configurationAccessor) && !basicUser.getFcmTokens().isEmpty();
    }

    public void destroy() {
        this.instances.clear();
    }

    @PostConstruct
    public void initialize() {
        this.instances = this.clusterHandler.getLocalStorage(LocalStorageType.FIREBASE_INSTANCES);
        this.instances.addRemoveListener((string, firebaseApp) -> firebaseApp.delete());
    }

    public FirebaseApp instantiateApp(String string) throws AppNotificationException {
        if (StringHelper.isBlank((Object)string)) {
            throw new IllegalArgumentException("Firebase credentials are required");
        }
        return (FirebaseApp)this.instances.get((Object)string, () -> this.doInstantiateApp(string));
    }

    public boolean isEnabled(ConfigurationAccessor configurationAccessor) {
        String string = configurationAccessor.getFirebasePrivateKey();
        return StringHelper.isNotBlank((Object)string);
    }

    public boolean notify(AppNotificationMessage appNotificationMessage) {
        FirebaseMessaging firebaseMessaging = this.getFirebaseMessaging(appNotificationMessage.getUser(), true);
        if (firebaseMessaging == null) {
            return false;
        }
        try {
            this.doNotify(firebaseMessaging, appNotificationMessage, false);
            return true;
        }
        catch (AppNotificationException appNotificationException) {
            return false;
        }
    }

    public <T> T unwrap(Class<T> clazz, BasicUser basicUser) {
        if (!this.canReceiveNotifications(basicUser)) {
            return null;
        }
        if (FirebaseMessaging.class.isAssignableFrom(clazz)) {
            return (T)this.getFirebaseMessaging(basicUser, true);
        }
        if (FirebaseApp.class.isAssignableFrom(clazz)) {
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
            String string = configurationAccessor.getFirebasePrivateKey();
            return (T)(StringHelper.isBlank((Object)string) ? null : this.instantiateApp(string));
        }
        return null;
    }

    public void validate(BasicUser basicUser, Object object) {
        try {
            FirebaseMessaging firebaseMessaging = this.getFirebaseMessaging(basicUser, false);
            if (firebaseMessaging == null) {
                return;
            }
            AppNotificationMessage appNotificationMessage = AppNotificationMessage.builder().setBody("BODY").setTitle("TITLE").setUser(basicUser).build();
            this.doNotify(firebaseMessaging, appNotificationMessage, Collections.singleton((String)object), true);
        }
        catch (AppNotificationException appNotificationException) {
            if (appNotificationException.getCause() instanceof FirebaseMessagingException) {
                this.throwValidationErrorIfNeeded((FirebaseMessagingException)appNotificationException.getCause());
            }
            throw appNotificationException;
        }
    }

    private Message createMessage(AppNotificationMessage appNotificationMessage, String string) {
        Notification notification = this.createNotification(appNotificationMessage, string);
        return Message.builder().putAllData(this.resolveData(appNotificationMessage)).setToken(string).setNotification(notification).setApnsConfig(this.toApnsConfig(appNotificationMessage)).setAndroidConfig(this.toAndroidConfig(appNotificationMessage)).build();
    }

    private Pair<MulticastMessage, MulticastMessage> createMulticastMessages(AppNotificationMessage appNotificationMessage, Set<String> set2) {
        String string;
        BiFunction<Set, Notification, MulticastMessage> biFunction = (set, notification) -> MulticastMessage.builder().putAllData(this.resolveData(appNotificationMessage)).addAllTokens((Collection)set).setNotification(notification).setApnsConfig(this.toApnsConfig(appNotificationMessage)).setAndroidConfig(this.toAndroidConfig(appNotificationMessage)).build();
        Pair<Set<String>, Set<String>> pair = this.divideTokensByMessageContent(set2);
        Set set3 = (Set)pair.getFirst();
        Set set4 = (Set)pair.getSecond();
        BasicUser basicUser = appNotificationMessage.getUser();
        MulticastMessage multicastMessage = null;
        MulticastMessage multicastMessage2 = null;
        if (!set3.isEmpty()) {
            string = this.getPrefixedBody(basicUser, appNotificationMessage.getBody());
            Notification notification2 = this.createNotification(basicUser, string, appNotificationMessage.getTitle(), appNotificationMessage.getImageUrl());
            multicastMessage = biFunction.apply(set3, notification2);
        }
        if (!set4.isEmpty()) {
            string = this.createNotification(basicUser, appNotificationMessage.getBody(), appNotificationMessage.getTitle(), appNotificationMessage.getImageUrl());
            multicastMessage2 = biFunction.apply(set4, (Notification)string);
        }
        return Pair.create(multicastMessage, multicastMessage2);
    }

    private Notification createNotification(AppNotificationMessage appNotificationMessage, String string) {
        QUserFcmToken qUserFcmToken = QUserFcmToken.userFcmToken;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qUserFcmToken}).where((Predicate)qUserFcmToken.token.eq((Object)string))).count(qUserFcmToken.id) > 1;
        String string2 = !bl ? appNotificationMessage.getBody() : this.getPrefixedBody(appNotificationMessage.getUser(), appNotificationMessage.getBody());
        return this.createNotification(appNotificationMessage.getUser(), string2, appNotificationMessage.getTitle(), appNotificationMessage.getImageUrl());
    }

    private Notification createNotification(BasicUser basicUser, String string, String string2, String string3) {
        return (Notification)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)basicUser), () -> {
            Function function = this.profileFieldHandler.getUserVariablesFunction(basicUser);
            return Notification.builder().setBody(StringHelper.replaceVariables((String)string, (Function)function)).setTitle(StringHelper.replaceVariables((String)string2, (Function)function)).setImage(string3).build();
        });
    }

    private Pair<Set<String>, Set<String>> divideTokensByMessageContent(Set<String> set) {
        QUserFcmToken qUserFcmToken = QUserFcmToken.userFcmToken;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        set.stream().forEach(string -> {
            if (((DBQuery)this.from(new EntityPath[]{qUserFcmToken}).where((Predicate)qUserFcmToken.token.eq(string))).count(qUserFcmToken.id) > 1) {
                hashSet.add(string);
            } else {
                hashSet2.add(string);
            }
        });
        return Pair.create(hashSet, hashSet2);
    }

    private FirebaseApp doInstantiateApp(String string) throws AppNotificationException {
        try {
            FirebaseOptions firebaseOptions = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)))).build();
            return FirebaseApp.initializeApp((FirebaseOptions)firebaseOptions, (String)("cyclos_" + System.currentTimeMillis()));
        }
        catch (Exception exception) {
            throw new AppNotificationException("Error initializing FirebaseApp", (Throwable)exception);
        }
    }

    private void doNotify(FirebaseMessaging firebaseMessaging, AppNotificationMessage appNotificationMessage, boolean bl) throws AppNotificationException {
        this.doNotify(firebaseMessaging, appNotificationMessage, appNotificationMessage.getUser().getFcmTokens().stream().map(UserFcmToken::getToken).collect(Collectors.toSet()), bl);
    }

    private void doNotify(FirebaseMessaging firebaseMessaging, AppNotificationMessage appNotificationMessage, Set<String> set, boolean bl) throws AppNotificationException {
        try {
            if (CollectionHelper.size(set) == 1) {
                Message message = this.createMessage(appNotificationMessage, set.iterator().next());
                firebaseMessaging.send(message, bl);
            } else {
                Pair<MulticastMessage, MulticastMessage> pair = this.createMulticastMessages(appNotificationMessage, set);
                MulticastMessage multicastMessage = (MulticastMessage)pair.getFirst();
                if (multicastMessage != null) {
                    firebaseMessaging.sendEachForMulticast(multicastMessage, bl);
                }
                if ((multicastMessage = (MulticastMessage)pair.getSecond()) != null) {
                    firebaseMessaging.sendEachForMulticast(multicastMessage, bl);
                }
            }
        }
        catch (FirebaseMessagingException firebaseMessagingException) {
            String string = String.format("Error sending FCM %s", bl ? "token validation" : "app message: " + appNotificationMessage.getTitle());
            this.getLogger().error(string, (Throwable)firebaseMessagingException);
            throw new AppNotificationException(string, (Throwable)firebaseMessagingException);
        }
    }

    private FirebaseMessaging getFirebaseMessaging(BasicUser basicUser, boolean bl) throws AppNotificationException {
        if (basicUser == null) {
            return null;
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        String string = configurationAccessor.getFirebasePrivateKey();
        if (StringHelper.isBlank((Object)string) || bl && CollectionHelper.isEmpty((Iterable)basicUser.getFcmTokens())) {
            return null;
        }
        FirebaseApp firebaseApp = this.instantiateApp(string);
        return FirebaseMessaging.getInstance((FirebaseApp)firebaseApp);
    }

    private String getPrefixedBody(BasicUser basicUser, String object) {
        if (StringHelper.isNotBlank((Object)basicUser.getDisplayForOthers())) {
            object = basicUser.getDisplayForOthers() + ": " + (String)object;
        }
        return object;
    }

    private Map<String, String> resolveData(AppNotificationMessage appNotificationMessage) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (appNotificationMessage.getVariables() != null) {
            hashMap.putAll(appNotificationMessage.getVariables());
        }
        String string = this.applicationHandler.getIdMask().apply(appNotificationMessage.getUser().getId()).toString();
        hashMap.put(USER_ID_APP_NOTIFICATION_PAYLOAD, string);
        if (appNotificationMessage.getCustomUrl() != null) {
            hashMap.put(CUSTOM_URL_APP_NOTIFICATION_PAYLOAD, appNotificationMessage.getCustomUrl());
        }
        return hashMap;
    }

    private void throwValidationErrorIfNeeded(FirebaseMessagingException firebaseMessagingException) throws ValidationException {
        if (Stream.of(TOKEN_RELATED_ERRORS).anyMatch(string -> string.equals(firebaseMessagingException.getErrorCode()))) {
            throw new ValidationException("Invalid registration token (" + String.valueOf(firebaseMessagingException.getErrorCode()) + ")");
        }
    }

    private AndroidConfig toAndroidConfig(AppNotificationMessage appNotificationMessage) {
        AndroidNotification.Builder builder = AndroidNotification.builder().setDefaultSound(true).setDefaultLightSettings(true).setColor(appNotificationMessage.getAndroidIconColor());
        return AndroidConfig.builder().setNotification(builder.build()).build();
    }

    private ApnsConfig toApnsConfig(AppNotificationMessage appNotificationMessage) {
        Aps.Builder builder = Aps.builder().setSound("default").setBadge(appNotificationMessage.isIosUseBadge() ? 1 : 0);
        return ApnsConfig.builder().setAps(builder.build()).build();
    }
}

