/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.User;
import org.cyclos.impl.sql.postgresql.querytypes.SBrokerings;
import org.cyclos.impl.utils.AbstractUserVisibilityApplier;

public class SQLUserVisibilityApplier
extends AbstractUserVisibilityApplier {
    private SQLQuery<?> query;
    private NumberPath<Long> userId;
    private NumberPath<Long> groupId;

    public SQLUserVisibilityApplier(SQLQuery<?> sQLQuery, NumberPath<Long> numberPath, NumberPath<Long> numberPath2) {
        this.query = sQLQuery;
        this.userId = numberPath;
        this.groupId = numberPath2;
    }

    @Override
    protected void applyBrokerOrSelf(User user) {
        this.query.where((Predicate)this.brokerExpr(user).or((Predicate)this.selfExpr(user)));
    }

    @Override
    protected void applyGroups(Set<Group> set) {
        this.query.where((Predicate)this.groupsExpr(set));
    }

    @Override
    protected void applyGroupsOrBrokerOrSelf(Set<Group> set, User user) {
        this.query.where((Predicate)this.groupsExpr(set).or((Predicate)this.brokerExpr(user)).or((Predicate)this.selfExpr(user)));
    }

    @Override
    protected void applyGroupsOrSelf(Set<Group> set, User user) {
        this.query.where((Predicate)this.groupsExpr(set).or((Predicate)this.selfExpr(user)));
    }

    @Override
    protected void applySelf(User user) {
        this.query.where((Predicate)this.selfExpr(user));
    }

    @Override
    protected void bogusCondition() {
        this.query.where((Predicate)this.userId.isNull());
    }

    private BooleanExpression brokerExpr(User user) {
        SBrokerings sBrokerings = new SBrokerings("bn2");
        BooleanExpression booleanExpression = ((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sBrokerings)).where(new Predicate[]{sBrokerings.userId.eq(this.userId), sBrokerings.endDate.isNull().or((Predicate)sBrokerings.endDate.after((Expression)DateTimeExpression.currentTimestamp())), sBrokerings.brokerId.eq((Object)user.getId())})).exists();
        return booleanExpression;
    }

    private BooleanExpression groupsExpr(Set<Group> set) {
        Set set2 = SimpleEntity.uniqueIds(set);
        return this.groupId.in((Collection)set2);
    }

    private BooleanExpression selfExpr(User user) {
        return this.userId.eq((Object)user.getId());
    }
}

